<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use Hash;

class AuthController extends Controller
{
public function login()
{
    // Define roles mapping
    $roles = [
        2 => 'Cashier',
        3 => 'Waiter',
        6 => 'Validator'
    ];

    // Get only users who are waiters or cashiers (is_role 2 or 3)
    $users = User::whereIn('is_role', [2, 3, 6])
        ->get(['id', 'username', 'name', 'is_role'])
        ->map(function ($user) use ($roles) {
            $user->role_name = $roles[$user->is_role] ?? 'User';
            return $user;
        });

    return view('auth.login', compact('users'));
}


    public function login_post(Request $request)
    {
        if(Auth::attempt(['username' => $request->username, 'password'=> $request->password], true))
        {
            if(Auth::user()->is_role == '1')
            {
                return redirect()->intended('/dashboard');
            } 
            else if(Auth::user()->is_role == '2')
            {
                return redirect()->intended('/dashboard');
            }
            else if(Auth::user()->is_role == '3')
            {
                return redirect()->intended('/sales');
            }
            else if(Auth::user()->is_role == '6') // Validator - NEW ROLE
            {
                return redirect()->intended('/validator/dashboard');
            }
            else
                {
                    return redirect('/')->with('error', 'username not found');
                }
        } 
            else
                {
                    return redirect('/')->with('error', 'check username or pasword');
                }    
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect(url('/'));
    }
}
