<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Auth;

class CategoryController extends Controller
{
    public function index(Request $request)
    {
        return view('category.list');

    }

    public function getCategories()
    {
        $categories = Category::all();
        return response()->json($categories);
    }

    public function store(Request $request)
    {
        $request->validate([
            'category_name' => 'required|string|max:255'
        ]);

        $category = Category::create([
            'category_name' => $request->category_name
        ]);

        return response()->json($category);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'category_name' => 'required|string|max:255'
        ]);


        $category = category::findOrFail($id);
        $category->update($request->all());

        return response()->json($category);
    }

    
    public function destroy($id)
    {
        $category = Category::findOrFail($id);
        $category->delete();

        return response()->json([
            'success' => true,
            'category_name' => $category->category_name
        ]);
    }


}