<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stocktaking extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'date',
        'opening_stock',
        'additional_stock',
        'buying_price',
        'selling_price',
        'sold_quantity',
        'created_by'
    ];

    protected $casts = [
        'date' => 'date',
        'buying_price' => 'decimal:2',
        'selling_price' => 'decimal:2',
        'opening_stock' => 'integer',
        'additional_stock' => 'integer',
        'sold_quantity' => 'integer'
    ];

    // Add these appends to include calculated fields in JSON
    protected $appends = ['amount_obtained', 'profit', 'closed_stock'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function cashier()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Calculate derived values
    public function getAmountObtainedAttribute()
    {
        return $this->sold_quantity * $this->selling_price;
    }

    public function getProfitAttribute()
    {
        $cost = $this->sold_quantity * $this->buying_price;
        return $this->amount_obtained - $cost;
    }

    public function getClosedStockAttribute()
    {
        return ($this->opening_stock + $this->additional_stock) - $this->sold_quantity;
    }
}