<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
protected $fillable = [
    'name',
    'username',
    'email',
    'password',
    'is_role',
    'status',
];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

        public function sales()
    {
        return $this->hasMany(Sale::class, 'waiter_id');
    }

    /**
     * Get all sales verified by this cashier
     */
    public function verifiedSales()
    {
        return $this->hasMany(Sale::class, 'cashier_id');
    }
        /**
     * Check if user is admin
     */
    public function isAdmin()
    {
        return $this->is_role == 1;
    }

    /**
     * Check if user is cashier
     */
    public function isCashier()
    {
        return $this->is_role == 2;
    }

    /**
     * Check if user is waiter
     */
    public function isWaiter()
    {
        return $this->is_role == 3;
    }
}
