<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->BigIncrements('id');
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');
            $table->string('product_name')->nullable();
            $table->string('stock')->default('0');
            $table->string('purchase_price')->default('0');
            $table->string('selling_price')->default('0');
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
