<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('stocktakings', function (Blueprint $table) {
            $table->foreign(['product_id'], 'stocktakings_ibfk_1')->references(['id'])->on('products')->onUpdate('restrict')->onDelete('cascade');
            $table->foreign(['created_by'], 'stocktakings_ibfk_2')->references(['id'])->on('users')->onUpdate('restrict')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('stocktakings', function (Blueprint $table) {
            $table->dropForeign('stocktakings_ibfk_1');
            $table->dropForeign('stocktakings_ibfk_2');
        });
    }
};
