@extends('layouts.admin')

@section('title', 'Waiters Payroll - Weekly Summary')

@section('content')
<div class="content">
    <div class="pb-5">

        <!-- Header and Filters -->
        <div class="mb-4">
            <div class="row">
                <div class="col-md-6">
                    <h2 class="mb-1">Weekly Payroll Summary</h2>
                    <p class="text-body-tertiary">
                        Week {{ $week }} of {{ $year }}
                        ({{ $weekStart->format('M j') }} - {{ $weekEnd->format('M j, Y') }})
                    </p>
                </div>

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <form method="GET" action="{{ route('payroll.index') }}" class="row g-2">
                                <div class="col-md-5">
                                    <label class="form-label small">Year</label>
                                    <select name="year" class="form-select form-select-sm">
                                        @foreach($availableYears as $availableYear)
                                            <option value="{{ $availableYear }}" {{ $year == $availableYear ? 'selected' : '' }}>
                                                {{ $availableYear }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-5">
                                    <label class="form-label small">Week</label>
                                    <select name="week" class="form-select form-select-sm">
                                        @for($i = 1; $i <= 52; $i++)
                                            <option value="{{ $i }}" {{ $week == $i ? 'selected' : '' }}>
                                                Week {{ $i }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>

                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary btn-sm w-100">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Weekly Summary Table -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card">
                    
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Weekly Payroll Summary</h5>
                        <a href="{{ route('payroll.export', ['year' => $year, 'week' => $week]) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-file-pdf me-1"></i> Export PDF
                        </a>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-body-secondary">
                                    <tr>
                                        <th class="ps-4">#</th>
                                        <th>Waiter Name</th>
                                        <th class="text-center">Total Weekly Sales (TZS)</th>
                                        <th class="text-center">Weekly Payment (TZS)</th>
                                        <th class="text-center">Eligible Days</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($waiters as $index => $waiter)
                                    @php
                                        $eligibleDays = count(array_filter($waiter['daily'], fn($day) => $day['is_eligible']));
                                    @endphp

                                    <tr>
                                        <td class="ps-4">{{ $index + 1 }}</td>

                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if($waiter['avatar'])
                                                    <img src="{{ asset('storage/' . $waiter['avatar']) }}"
                                                         class="rounded-circle me-2" width="32" height="32">
                                                @else
                                                    <div class="bg-secondary text-white rounded-circle me-2 d-flex align-items-center justify-content-center"
                                                         style="width: 32px; height: 32px;">
                                                        <i class="fas fa-user"></i>
                                                    </div>
                                                @endif
                                                <span>{{ $waiter['name'] }}</span>
                                            </div>
                                        </td>

                                        <td class="text-center">{{ number_format($waiter['weekly_total_sales'], 0) }}</td>

                                        <td class="text-center fw-bold {{ $waiter['weekly_total_payment'] > 0 ? 'text-success' : 'text-muted' }}">
                                            @if(strtolower($waiter['name']) === 'tumaini george')
                                                <span class="text-info">Paid Monthly</span>
                                            @else
                                                {{ number_format($waiter['weekly_total_payment'], 0) }}
                                            @endif
                                        </td>

                                        <td class="text-center">{{ $eligibleDays }}</td>
                                        <td class="text-center">
                                            @if(strtolower($waiter['name']) === 'tumaini george')
                                                <span class="badge bg-info">Paid Monthly</span>
                                            @elseif($waiter['weekly_total_payment'] > 0)
                                                <span class="badge bg-success">Payable</span>
                                            @else
                                                <span class="badge bg-secondary">No Payment</span>
                                            @endif
                                        </td>
                                    </tr>

                                    @endforeach

                                    @if(count($waiters) == 0)
                                    <tr>
                                        <td colspan="6" class="text-center text-muted py-3">
                                            No waiters found for this week.
                                        </td>
                                    </tr>
                                    @endif

                                </tbody>

                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <!-- Daily Breakdown -->
        @foreach($waiters as $waiter)
        <div class="row mb-5">
            <div class="col-12">
                
                <div class="card">

                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            {{ $waiter['name'] }} - Daily Breakdown
                            <small class="text-muted ms-2">(Week {{ $week }})</small>
                        </h5>
                        <div class="text-end">
                            <small class="text-muted">Weekly Sales: {{ number_format($waiter['weekly_total_sales'], 0) }} TZS</small><br>
                            <small class="text-success fw-bold">Payment: {{ number_format($waiter['weekly_total_payment'], 0) }} TZS</small>
                        </div>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive">

                            <table class="table table-hover mb-0">
                                <thead class="bg-body-secondary">
                                    <tr>
                                        <th class="ps-4">Day</th>
                                        <th class="text-center">Date</th>
                                        <th class="text-center">Sales Count</th>
                                        <th class="text-center">Total Sales (TZS)</th>
                                        <th class="text-center">4% Value (TZS)</th>
                                        <th class="text-center">Payment (TZS)</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                </thead>

                                <tbody>
                                @foreach($waiter['daily'] as $dayData)
                                    @php
                                        $fourPercentValue = $dayData['total_amount'] * 0.04;
                                    @endphp

                                    <tr>
                                        <td class="ps-4"><strong>{{ $dayData['day_name'] }}</strong></td>
                                        <td class="text-center">{{ $dayData['date'] }}</td>
                                        <td class="text-center">{{ $dayData['sales_count'] }}</td>
                                        <td class="text-center">{{ number_format($dayData['total_amount'], 0) }}</td>
                                        <td class="text-center">{{ number_format($fourPercentValue, 0) }}</td>

                                        <td class="text-center fw-bold {{ $dayData['is_eligible'] ? 'text-success' : 'text-muted' }}">
                                            @if(strtolower($waiter['name']) === 'tumaini george')
                                                <span class="text-info">Monthly</span>
                                            @else
                                                {{ number_format($dayData['payment'], 0) }}
                                            @endif
                                        </td>

                                        <td class="text-center">
                                            <span class="badge bg-{{ $dayData['is_eligible'] ? 'success' : 'secondary' }}">
                                                {{ $dayData['is_eligible'] ? 'Eligible' : 'Not Eligible' }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                                <tfoot class="bg-light">
                                    <tr>
                                        <td colspan="3" class="ps-4"><strong>Weekly Totals</strong></td>

                                        <!-- weekly sales from controller -->
                                        <td class="text-center fw-bold">
                                            {{ number_format($waiter['weekly_total_sales'], 0) }}
                                        </td>

                                        <!-- weekly 4% removed — replaced with dash -->
                                        <td class="text-center fw-bold">-</td>

                                        <!-- weekly payment from controller -->
                                        <td class="text-center fw-bold text-success">
                                            {{ number_format($waiter['weekly_total_payment'], 0) }}
                                        </td>

                                        <td></td>
                                    </tr>
                                </tfoot>

                            </table>

                        </div>
                    </div>

                </div>

            </div>
        </div>
        @endforeach

    </div>
</div>
@endsection

@push('styles')
<style>
.card {
    border: none;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}
.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
}
.table th {
    border-top: none;
    font-weight: 600;
    font-size: 0.875rem;
    text-transform: uppercase;
    color: #6c757d;
}
.badge {
    font-size: 0.75rem;
}
</style>
@endpush

@push('scripts')
<script>
document.addEventListener("DOMContentLoaded", function() {
    if (typeof feather !== 'undefined') {
        feather.replace();
    }
});
</script>
@endpush
