<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $waiter->name }} - Performance Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #2c3e50;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 18px;
            color: #7f8c8d;
        }
        .summary-section {
            margin-bottom: 20px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        .summary-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }
        .summary-card {
            text-align: center;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background: white;
        }
        .summary-card h3 {
            margin: 0 0 5px 0;
            font-size: 18px;
        }
        .summary-card p {
            margin: 0;
            color: #666;
            font-size: 11px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .table th,
        .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .badge {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-warning { background: #fff3cd; color: #856404; }
        .badge-primary { background: #d1ecf1; color: #0c5460; }
        .badge-info { background: #d1ecf1; color: #0c5460; }
        .badge-danger { background: #f8d7da; color: #721c24; }
        .progress {
            height: 8px;
            background-color: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
            margin: 5px 0;
        }
        .progress-bar {
            height: 100%;
            background-color: #007bff;
        }
        .section-title {
            background: #2c3e50;
            color: white;
            padding: 8px 12px;
            margin: 20px 0 10px 0;
            font-size: 14px;
            font-weight: bold;
        }
        .two-column {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 10px;
        }
        .text-success { color: #28a745; }
        .text-danger { color: #dc3545; }
        .text-primary { color: #007bff; }
        .text-warning { color: #ffc107; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .mb-0 { margin-bottom: 0; }
        .mb-2 { margin-bottom: 10px; }
        .mb-3 { margin-bottom: 15px; }
        .mt-3 { margin-top: 15px; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>D-RESTAURANT</h1>
        <h2>Waiter Performance Report</h2>
        <p><strong>Waiter:</strong> {{ $waiter->name }} | <strong>Generated:</strong> {{ date('d-M-Y H:i:s') }}</p>
        <p><strong>Period:</strong> 
            @if($filter == 'today')
                Today ({{ \Carbon\Carbon::parse($date)->format('d M Y') }})
            @elseif($filter == 'week')
                Week {{ $week }}, {{ $year }}
            @elseif($filter == 'month')
                {{ DateTime::createFromFormat('!m', $month)->format('F') }} {{ $year }}
            @elseif($filter == 'year')
                Year {{ $year }}
            @else
                Custom Period
            @endif
        </p>
    </div>

    <!-- Waiter Profile -->
    <div class="summary-section">
        <div style="display: flex; align-items: center; margin-bottom: 15px;">
            <div style="flex-shrink: 0; margin-right: 15px;">
                @if($waiter->avatar)
                    <img src="{{ $waiter->avatar }}" style="width: 60px; height: 60px; border-radius: 50%; object-fit: cover;" alt="{{ $waiter->name }}">
                @else
                    <div style="width: 60px; height: 60px; border-radius: 50%; background: #007bff; color: white; display: flex; align-items: center; justify-content: center; font-size: 20px; font-weight: bold;">
                        {{ substr($waiter->name, 0, 1) }}
                    </div>
                @endif
            </div>
            <div style="flex-grow: 1;">
                <h3 style="margin: 0 0 5px 0;">{{ $waiter->name }}</h3>
                <p style="margin: 0; color: #666;">Waiter | Employee ID: {{ $waiter->id }}</p>
            </div>
        </div>
    </div>

    <!-- Key Performance Indicators -->
    <div class="section-title">KEY PERFORMANCE INDICATORS</div>
    <div class="summary-grid">
        <div class="summary-card">
            <h3 class="text-primary">{{ $totalSales }}</h3>
            <p>Total Sales</p>
            <small class="{{ $salesGrowth >= 0 ? 'text-success' : 'text-danger' }}">
                {{ $salesGrowth >= 0 ? '+' : '' }}{{ number_format($salesGrowth, 1) }}%
            </small>
        </div>
        <div class="summary-card">
            <h3 class="text-success">Tsh {{ number_format($totalAmount, 0) }}</h3>
            <p>Total Revenue</p>
            <small class="{{ $amountGrowth >= 0 ? 'text-success' : 'text-danger' }}">
                {{ $amountGrowth >= 0 ? '+' : '' }}{{ number_format($amountGrowth, 1) }}%
            </small>
        </div>
        <div class="summary-card">
            <h3 class="text-info">{{ $totalItems }}</h3>
            <p>Items Sold</p>
            <small class="{{ $itemsGrowth >= 0 ? 'text-success' : 'text-danger' }}">
                {{ $itemsGrowth >= 0 ? '+' : '' }}{{ number_format($itemsGrowth, 1) }}%
            </small>
        </div>
        <div class="summary-card">
            <h3 class="text-warning">Tsh {{ number_format($averageSale, 0) }}</h3>
            <p>Average Sale Value</p>
            <small>Per Transaction</small>
        </div>
    </div>

    <!-- Performance Scores -->
    <div class="two-column">
        <div>
            <div class="section-title">PERFORMANCE SCORES</div>
            <div style="background: white; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">
                <!-- Efficiency Score -->
                <div style="margin-bottom: 15px;">
                    <div style="display: flex; justify-content: between; align-items: center; margin-bottom: 5px;">
                        <span style="font-weight: bold;">Efficiency Score</span>
                        <span style="font-weight: bold;">{{ number_format($efficiencyScore, 1) }}/100</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar" style="width: {{ $efficiencyScore }}%; background-color: {{ $efficiencyScore >= 80 ? '#28a745' : ($efficiencyScore >= 60 ? '#ffc107' : '#dc3545') }};"></div>
                    </div>
                    <small style="color: #666;">Based on items per sale and transaction speed</small>
                </div>

                <!-- Customer Value Score -->
                <div>
                    <div style="display: flex; justify-content: between; align-items: center; margin-bottom: 5px;">
                        <span style="font-weight: bold;">Customer Value Score</span>
                        <span style="font-weight: bold;">{{ number_format($customerValueScore, 1) }}/100</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar" style="width: {{ $customerValueScore }}%; background-color: {{ $customerValueScore >= 80 ? '#28a745' : ($customerValueScore >= 60 ? '#ffc107' : '#dc3545') }};"></div>
                    </div>
                    <small style="color: #666;">Based on average transaction value</small>
                </div>
            </div>
        </div>

        <div>
            <div class="section-title">BREAKDOWN</div>
            <div style="background: white; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">
                <!-- Payment Method Breakdown -->
                <h4 style="margin: 0 0 10px 0; font-size: 12px;">Payment Methods</h4>
                <table style="width: 100%; font-size: 10px;">
                    @foreach($paymentBreakdown as $method => $data)
                    <tr>
                        <td>{{ $method }}</td>
                        <td class="text-right">{{ $data['count'] }} sales</td>
                        <td class="text-right">Tsh {{ number_format($data['amount'], 0) }}</td>
                        <td class="text-right">{{ $totalAmount > 0 ? number_format(($data['amount'] / $totalAmount) * 100, 1) : 0 }}%</td>
                    </tr>
                    @endforeach
                </table>

                <!-- Status Breakdown -->
                <h4 style="margin: 15px 0 10px 0; font-size: 12px;">Sales Status</h4>
                <table style="width: 100%; font-size: 10px;">
                    @foreach($statusBreakdown as $status => $data)
                    <tr>
                        <td>
                            <span class="badge badge-{{ $status == 'verified' ? 'success' : 'warning' }}">
                                {{ ucfirst($status) }}
                            </span>
                        </td>
                        <td class="text-right">{{ $data['count'] }}</td>
                        <td class="text-right">{{ $totalSales > 0 ? number_format(($data['count'] / $totalSales) * 100, 1) : 0 }}%</td>
                    </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>

    <!-- Top Selling Items -->
    <div class="section-title">TOP SELLING ITEMS</div>
    <table class="table">
        <thead>
            <tr>
                <th>Item Name</th>
                <th class="text-right">Quantity</th>
                <th class="text-right">Revenue</th>
                <th class="text-right">Percentage</th>
            </tr>
        </thead>
        <tbody>
            @foreach($topItems as $item => $data)
            <tr>
                <td>{{ $item }}</td>
                <td class="text-right">{{ $data['quantity'] }}</td>
                <td class="text-right">Tsh {{ number_format($data['amount'], 0) }}</td>
                <td class="text-right">
                    {{ $totalAmount > 0 ? number_format(($data['amount'] / $totalAmount) * 100, 1) : 0 }}%
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Recent Sales -->
    <div class="section-title">RECENT SALES (Last 20)</div>
    <table class="table">
        <thead>
            <tr>
                <th>Sale ID</th>
                <th>Date & Time</th>
                <th>Items</th>
                <th class="text-right">Amount</th>
                <th>Payment</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sales->take(20) as $sale)
            <tr>
                <td>#{{ $sale->id }}</td>
                <td>{{ $sale->created_at->format('d/m H:i') }}</td>
                <td>
                    {{ $sale->items->count() }} items
                    @if($sale->items->count() > 0)
                        - {{ $sale->items->first()->product->product_name ?? 'Item' }}
                        @if($sale->items->count() > 1)
                            +{{ $sale->items->count() - 1 }}
                        @endif
                    @endif
                </td>
                <td class="text-right">Tsh {{ number_format($sale->total, 0) }}</td>
                <td>
                    <span class="badge badge-{{ $sale->payment_type == 'Cash' ? 'primary' : 'info' }}">
                        {{ $sale->payment_type }}
                    </span>
                </td>
                <td>
                    <span class="badge badge-{{ $sale->status == 'verified' ? 'success' : 'warning' }}">
                        {{ ucfirst($sale->status) }}
                    </span>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Performance Summary -->
    <div class="section-title">PERFORMANCE SUMMARY</div>
    <div style="background: #f8f9fa; padding: 15px; border-radius: 5px;">
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; font-size: 11px;">
            <div>
                <strong>Overall Performance:</strong> 
                @php
                    $overallScore = ($efficiencyScore + $customerValueScore) / 2;
                @endphp
                <span class="badge badge-{{ $overallScore >= 80 ? 'success' : ($overallScore >= 60 ? 'warning' : 'danger') }}">
                    {{ $overallScore >= 80 ? 'Excellent' : ($overallScore >= 60 ? 'Good' : 'Needs Improvement') }}
                </span>
            </div>
            <div>
                <strong>Sales Growth:</strong> 
                <span class="{{ $salesGrowth >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ $salesGrowth >= 0 ? '+' : '' }}{{ number_format($salesGrowth, 1) }}%
                </span>
            </div>
            <div>
                <strong>Revenue Growth:</strong> 
                <span class="{{ $amountGrowth >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ $amountGrowth >= 0 ? '+' : '' }}{{ number_format($amountGrowth, 1) }}%
                </span>
            </div>
            <div>
                <strong>Most Used Payment:</strong> 
                @php
                    $topPayment = collect($paymentBreakdown)->sortByDesc('count')->first();
                    $topPaymentMethod = $topPayment ? array_key_first($paymentBreakdown->toArray()) : 'N/A';
                @endphp
                {{ $topPaymentMethod }}
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Generated by D-Restaurant System on {{ date('d-M-Y H:i:s') }}</p>
        <p>This report is confidential and intended for administrative use only.</p>
    </div>
</body>
</html>