@php
    // Initialize sales counts per hour (7:00 - 22:00)
    $hours = range(7, 22);
    $labels = [];
    $salesCounts = [];

    foreach ($hours as $h) {
        $labels[] = sprintf("%02d:00", $h);
        $salesCounts[] = $sales[$h] ?? 0; // $sales should be ['hour' => count] format
    }
@endphp

<div id="salesTimelineChart" style="width:100%; min-height:320px;"></div>

@push('scripts')
<script>
document.addEventListener("DOMContentLoaded", function() {
    var chartDom = document.getElementById('salesTimelineChart');
    var myChart = echarts.init(chartDom);

    var option = {
        title: {
            text: 'Sales Timeline',
            left: 'center'
        },
        tooltip: {
            trigger: 'axis'
        },
        xAxis: {
            type: 'category',
            data: @json($labels),
            boundaryGap: false
        },
        yAxis: {
            type: 'value',
            name: 'Number of Sales'
        },
        series: [{
            name: 'Sales',
            type: 'line',
            data: @json($salesCounts),
            smooth: true,
            areaStyle: {}
        }],
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        }
    };

    myChart.setOption(option);

    // Make chart responsive
    window.addEventListener('resize', function() {
        myChart.resize();
    });
});
</script>
@endpush
