<!DOCTYPE html>
<html lang="en-US" dir="ltr" data-navigation-type="default" data-navbar-horizontal-shape="default">
<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title')</title>
<style>
@media (max-width: 768px) {
  html {
    zoom: 0.9; /* smaller text */
  }
  .btn {
    padding: 6px 12px;
    font-size: 0.8rem;
  }
  h1, h2, h3 {
    font-size: 90%; /* shrink headings */
  }
  .card, .chart-container {
    transform: scale(1.02);
    transform-origin: top center;
  }
}
</style>
       @include('includes.head')
       @stack('styles')

</head>
<script>
document.addEventListener('DOMContentLoaded', function() {
  const loadingText = document.getElementById('loading-text');
  let totalResources = 0;
  let loadedResources = 0;
  let progressInterval = null;

  // Count total number of resources
  function countInitialResources() {
    const links = document.querySelectorAll("link[rel='stylesheet']");
    const scripts = document.querySelectorAll("script[src]");
    const imgs = document.querySelectorAll("img");
    totalResources = links.length + scripts.length + imgs.length + 5; // +5 for fonts/DOM/misc
  }

  // Update progress on screen
  function updateProgress() {
    const percent = totalResources > 0
      ? Math.min(100, Math.floor((loadedResources / totalResources) * 100))
      : 0;
    loadingText.textContent = percent + "%";
  }

  // Fallback simulation (so it always moves)
  function startSimulatedProgress() {
    let fakeProgress = 0;
    progressInterval = setInterval(() => {
      if (fakeProgress < 95) {
        fakeProgress += Math.random() * 5;
        loadingText.textContent = Math.floor(fakeProgress) + "%";
      }
    }, 120);
  }

  function stopSimulatedProgress() {
    clearInterval(progressInterval);
  }

  // Start setup
  countInitialResources();
  updateProgress();
  startSimulatedProgress();

  // Real observer (if supported)
  let observerSupported = false;
  try {
    const observer = new PerformanceObserver((list) => {
      observerSupported = true;
      for (const entry of list.getEntries()) {
        loadedResources++;
        updateProgress();
      }
    });
    observer.observe({ type: "resource", buffered: true });
  } catch (e) {
    console.warn("PerformanceObserver not supported:", e);
  }

  // When fully loaded
  window.addEventListener("load", function() {
    stopSimulatedProgress();
    loadedResources = totalResources;
    updateProgress();
    setTimeout(() => {
      document.body.classList.add("loaded");
    }, 400);
  });

  // Reset loader when navigating
  const links = document.querySelectorAll("a:not([target='_blank']):not([href^='#'])");
  links.forEach(link => {
    link.addEventListener("click", () => {
      document.body.classList.remove("loaded");
      loadedResources = 0;
      updateProgress();
      startSimulatedProgress();
    });
  });
});
</script>




<body>
<div id="loader">
  <div class="loader-content">
    <div class="spinner"></div>
    <div id="loading-text">100%</div>
  </div>
</div>


 

     <main class="main" id="top">
  <!-- Sidebar -->
        @include('partials.sidebar')

    <!-- Navbar -->
            @include('partials.navbar')
      
   
            
      
  
 

      <div class="content" id="content">
        <div class="pb-5">     

            <!-- Content wrapper -->
 

                    @yield('content')
         

                <!-- Footer -->
                @include('partials.footer')
                <!-- /Footer -->
      </div>
 </div>
    </main>
 





<!-- Include JS scripts -->
@include('includes.scripts')
@stack('scripts')
<script>
  window.addEventListener("load", function() {
    document.body.classList.add("loaded");
  });
</script>

</body>
</html>
