  @include('partials.sidebar')
        @include('partials.navbar')

<div class="content">
    <div class="pb-5">
        <div class="row g-4">
            <div class="col-12">
                <!-- Page Header -->
                <div class="mb-8">
                    <h2 class="mb-2"><i class="fa-solid fa-cash-register me-2"></i>Point of Sale</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('cashier.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">POS System</li>
                        </ol>
                    </nav>
                </div>

                <!-- Main Card -->
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <!-- Left Column - Products -->
                            <div class="col-xxl-7 col-lg-6">
                                <div class="mb-4">
                                    <h4 class="mb-3"><i class="fa-solid fa-list me-2"></i>Product Catalog</h4>
                                    
                                    <!-- Category Tabs -->
                                    <ul class="nav nav-underline mb-3" id="categoryTabs" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="all-tab" data-bs-toggle="tab" 
                                                    data-bs-target="#all" type="button" role="tab" 
                                                    aria-controls="all" aria-selected="true">
                                                All Products
                                            </button>
                                        </li>
                                        @foreach($categories as $category)
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="category-{{ $category->id }}-tab" 
                                                    data-bs-toggle="tab" data-bs-target="#category-{{ $category->id }}" 
                                                    type="button" role="tab" 
                                                    aria-controls="category-{{ $category->id }}" 
                                                    aria-selected="false">
                                                {{ $category->name }}
                                            </button>
                                        </li>
                                        @endforeach
                                    </ul>

                                    <!-- Search Box -->
                                    <div class="search-box mb-3">
                                        <form class="position-relative">
                                            <input class="form-control search-input" type="search" 
                                                   placeholder="Search products..." 
                                                   id="productSearch" />
                                            <span class="fas fa-search search-box-icon"></span>
                                        </form>
                                    </div>

                                    <!-- Products Grid -->
                                    <div class="tab-content" id="categoryTabsContent">
                                        <div class="tab-pane fade show active" id="all" role="tabpanel" 
                                             aria-labelledby="all-tab">
                                            <div class="row g-3" id="productsGrid">
                                                @foreach($products as $product)
                                                <div class="col-xl-3 col-lg-4 col-sm-6">
                                                    <div class="card product-card h-100 cursor-pointer" 
                                                         onclick="addToCart({{ json_encode($product) }})">
                                                        <div class="card-body text-center p-3">
                                                            <h6 class="mb-2 text-truncate" title="{{ $product->name }}">
                                                                {{ $product->name }}
                                                            </h6>
                                                            <p class="text-success fw-bold mb-0">
                                                                ${{ number_format($product->selling_price, 2) }}
                                                            </p>
                                                            @if($product->stock <= 0)
                                                            <span class="badge bg-danger mt-1">Out of Stock</span>
                                                            @elseif($product->stock < 10)
                                                            <span class="badge bg-warning mt-1">Low Stock</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        
                                        @foreach($categories as $category)
                                        <div class="tab-pane fade" id="category-{{ $category->id }}" role="tabpanel" 
                                             aria-labelledby="category-{{ $category->id }}-tab">
                                            <div class="row g-3">
                                                @foreach($category->products as $product)
                                                <div class="col-xl-3 col-lg-4 col-sm-6">
                                                    <div class="card product-card h-100 cursor-pointer" 
                                                         onclick="addToCart({{ json_encode($product) }})">
                                                        <div class="card-body text-center p-3">
                                                            <h6 class="mb-2 text-truncate">{{ $product->name }}</h6>
                                                            <p class="text-success fw-bold mb-0">
                                                                ${{ number_format($product->selling_price, 2) }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column - Cart & Summary -->
                            <div class="col-xxl-5 col-lg-6">
                                <div class="card h-100">
                                    <div class="card-header">
                                        <h5 class="mb-0"><i class="fa-solid fa-receipt me-2"></i>Order Summary</h5>
                                    </div>
                                    <div class="card-body d-flex flex-column">
                                        <!-- Customer Selection -->
                                        <div class="mb-4">
                                            <label class="form-label">Customer</label>
                                            <select class="form-select" id="customerSelect">
                                                <option value="1">Walk-in Customer</option>
                                                @foreach($customers as $customer)
                                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <!-- Cart Items -->
                                        <div class="flex-grow-1 mb-4">
                                            <div class="table-responsive scrollbar">
                                                <table class="table table-sm table-hover mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th>Product</th>
                                                            <th class="text-center">Qty</th>
                                                            <th class="text-end">Price</th>
                                                            <th class="text-end">Total</th>
                                                            <th width="50px"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="cartItems">
                                                        <!-- Cart items will be populated here -->
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <!-- Totals -->
                                        <div class="border-top pt-3">
                                            <div class="row g-2 mb-3">
                                                <div class="col-6">
                                                    <span class="text-body">Subtotal:</span>
                                                </div>
                                                <div class="col-6 text-end">
                                                    <span class="fw-semibold" id="subtotal">$0.00</span>
                                                </div>
                                                <div class="col-6">
                                                    <span class="text-body">Tax (18%):</span>
                                                </div>
                                                <div class="col-6 text-end">
                                                    <span class="fw-semibold" id="taxAmount">$0.00</span>
                                                </div>
                                                <div class="col-6">
                                                    <span class="text-body fw-bold">Total:</span>
                                                </div>
                                                <div class="col-6 text-end">
                                                    <span class="fw-bold fs-5 text-success" id="grandTotal">$0.00</span>
                                                </div>
                                            </div>

                                            <!-- Payment Options -->
                                            <div class="mb-3">
                                                <label class="form-label">Payment Method</label>
                                                <select class="form-select" id="paymentMethod">
                                                    <option value="cash">Cash</option>
                                                    <option value="card">Credit/Debit Card</option>
                                                    <option value="mobile">Mobile Payment</option>
                                                </select>
                                            </div>

                                            <!-- Action Buttons -->
                                            <div class="d-grid gap-2">
                                                <button class="btn btn-danger" onclick="clearCart()" disabled id="clearBtn">
                                                    <i class="fa-solid fa-trash me-2"></i>Clear Cart
                                                </button>
                                                <div class="btn-group" role="group">
                                                    <button class="btn btn-warning" onclick="createBill()" disabled id="billBtn">
                                                        <i class="fa-solid fa-receipt me-2"></i>Create Bill
                                                    </button>
                                                    <button class="btn btn-primary" onclick="processPayment()" disabled id="payBtn">
                                                        <i class="fa-solid fa-credit-card me-2"></i>Process Payment
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Receipt Modal -->
<div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header text-center d-block">
                <h5 class="modal-title">RECEIPT</h5>
                <button type="button" class="btn-close position-absolute top-0 end-0 mt-2 me-2" 
                        data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-2">{{ $posSettings->company_name ?? 'Restaurant Name' }}</h6>
                <p class="fs-9 text-body-secondary mb-2">
                    {{ $posSettings->address ?? '' }}<br>
                    Tel: {{ $posSettings->phone ?? '' }}<br>
                    Date: {{ now()->format('M d, Y h:i A') }}
                </p>
                
                <div class="border-top pt-2">
                    <table class="table table-sm table-borderless fs-9 w-100">
                        <tbody id="receiptItems">
                            <!-- Receipt items will be populated here -->
                        </tbody>
                    </table>
                </div>
                
                <div class="border-top pt-2">
                    <div class="row fs-9">
                        <div class="col-6 text-start">Subtotal:</div>
                        <div class="col-6 text-end" id="receiptSubtotal">$0.00</div>
                        <div class="col-6 text-start">Tax (18%):</div>
                        <div class="col-6 text-end" id="receiptTax">$0.00</div>
                        <div class="col-6 text-start fw-bold">Total:</div>
                        <div class="col-6 text-end fw-bold" id="receiptTotal">$0.00</div>
                    </div>
                </div>
                
                <p class="fs-9 text-body-secondary mt-3">Thank you for your business!</p>
                
                <button class="btn btn-sm btn-outline-primary w-100 mt-2" onclick="printReceipt()">
                    <i class="fa-solid fa-print me-2"></i>Print Receipt
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Cart management
let cart = [];
const TAX_RATE = 0.18;

function addToCart(product) {
    const existingItem = cart.find(item => item.id === product.id);
    
    if (existingItem) {
        existingItem.quantity += 1;
    } else {
        cart.push({
            ...product,
            quantity: 1
        });
    }
    
    updateCartDisplay();
}

function removeFromCart(productId) {
    cart = cart.filter(item => item.id !== productId);
    updateCartDisplay();
}

function updateQuantity(productId, quantity) {
    const item = cart.find(item => item.id === productId);
    if (item) {
        item.quantity = Math.max(1, parseInt(quantity) || 1);
        updateCartDisplay();
    }
}

function clearCart() {
    if (confirm('Are you sure you want to clear the cart?')) {
        cart = [];
        updateCartDisplay();
    }
}

function updateCartDisplay() {
    const cartItems = document.getElementById('cartItems');
    const subtotalEl = document.getElementById('subtotal');
    const taxEl = document.getElementById('taxAmount');
    const grandTotalEl = document.getElementById('grandTotal');
    const clearBtn = document.getElementById('clearBtn');
    const billBtn = document.getElementById('billBtn');
    const payBtn = document.getElementById('payBtn');
    
    // Update cart items
    cartItems.innerHTML = cart.map(item => `
        <tr>
            <td class="align-middle">
                <h6 class="mb-0 fs-9">${item.name}</h6>
            </td>
            <td class="align-middle text-center">
                <input type="number" class="form-control form-control-sm" 
                       value="${item.quantity}" min="1" 
                       onchange="updateQuantity(${item.id}, this.value)"
                       style="width: 70px;">
            </td>
            <td class="align-middle text-end">$${item.selling_price.toFixed(2)}</td>
            <td class="align-middle text-end">$${(item.selling_price * item.quantity).toFixed(2)}</td>
            <td class="align-middle text-center">
                <button class="btn btn-sm btn-link text-danger p-0" 
                        onclick="removeFromCart(${item.id})">
                    <i class="fa-solid fa-times"></i>
                </button>
            </td>
        </tr>
    `).join('');
    
    // Calculate totals
    const subtotal = cart.reduce((sum, item) => sum + (item.selling_price * item.quantity), 0);
    const tax = subtotal * TAX_RATE;
    const grandTotal = subtotal + tax;
    
    // Update totals display
    subtotalEl.textContent = `$${subtotal.toFixed(2)}`;
    taxEl.textContent = `$${tax.toFixed(2)}`;
    grandTotalEl.textContent = `$${grandTotal.toFixed(2)}`;
    
    // Update button states
    const hasItems = cart.length > 0;
    clearBtn.disabled = !hasItems;
    billBtn.disabled = !hasItems;
    payBtn.disabled = !hasItems;
}

function processPayment() {
    if (cart.length === 0) return;
    
    const customerId = document.getElementById('customerSelect').value;
    const paymentMethod = document.getElementById('paymentMethod').value;
    const subtotal = cart.reduce((sum, item) => sum + (item.selling_price * item.quantity), 0);
    const tax = subtotal * TAX_RATE;
    const grandTotal = subtotal + tax;
    
    // Prepare receipt data
    document.getElementById('receiptItems').innerHTML = cart.map(item => `
        <tr>
            <td class="text-start">${item.name} x${item.quantity}</td>
            <td class="text-end">$${(item.selling_price * item.quantity).toFixed(2)}</td>
        </tr>
    `).join('');
    
    document.getElementById('receiptSubtotal').textContent = `$${subtotal.toFixed(2)}`;
    document.getElementById('receiptTax').textContent = `$${tax.toFixed(2)}`;
    document.getElementById('receiptTotal').textContent = `$${grandTotal.toFixed(2)}`;
    
    // Show receipt modal
    const receiptModal = new bootstrap.Modal(document.getElementById('receiptModal'));
    receiptModal.show();
}

function createBill() {
    if (cart.length === 0) return;
    
    // Similar to processPayment but for bill creation
    alert('Bill creation functionality would be implemented here');
}

function printReceipt() {
    window.print();
}

// Product search functionality
document.getElementById('productSearch').addEventListener('input', function(e) {
    const searchTerm = e.target.value.toLowerCase();
    const productCards = document.querySelectorAll('.product-card');
    
    productCards.forEach(card => {
        const productName = card.querySelector('h6').textContent.toLowerCase();
        if (productName.includes(searchTerm)) {
            card.parentElement.style.display = 'block';
        } else {
            card.parentElement.style.display = 'none';
        }
    });
});

// Initialize cart display
updateCartDisplay();
</script>

<style>
.product-card {
    transition: all 0.2s ease;
    cursor: pointer;
}

.product-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.cursor-pointer {
    cursor: pointer;
}

@media print {
    .btn-close, .btn {
        display: none !important;
    }
}
</style>
@endpush