<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - D RESTAURANT</title>
    <style>
        /* Thermal receipt styling - Desktop (unchanged) */
        .thermal-receipt {
            max-width: 80mm;
            margin: 0 auto;
            background-color: #ffffff;
            color: #000000;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 15px;
            border-radius: 5px;
            font-family: "Courier New", Courier, monospace;
        }

        /* Make all child text elements inherit the theme color */
        .thermal-receipt, 
        .thermal-receipt * {
            color: inherit !important;
            background-color: inherit !important;
        }

        .receipt-header {
            text-align: center;
            border-bottom: 0.5px dashed #333;
            padding-bottom: 10px;
            margin-bottom: 5px;
        }

        .receipt-header h2 {
            font-weight: bold;
            font-size: 20px;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }

        .receipt-header p {
            margin: 2px 0;
            font-size: 12px;
        }

        .receipt-info {
            margin-bottom: 5px;
            font-size: 12px;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 3px;
        }

        .info-item {
            flex: 1;
            display: flex;
            padding: 0 5px;
        }

        .info-item.full-width {
            flex: 0 0 100%;
            justify-content: left;
        }

        .receipt-info .label {
            font-weight: bold;
            width: 62px;
        }

        .receipt-info .value {
            text-align: left;
        }

        /* Added section heading style */
        .section-heading {
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            margin: 5px 0 10px 0;
            padding: 2px 0;
            border-top: 1px dashed #444;
            border-bottom: 1px dashed #444;
        }

        .receipt-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0px;
            font-size: 12px;
        }

        .receipt-table tr {
            border-bottom: 1px dashed #ccc;
        }

        .receipt-table td {
            padding: 5px 0;
            vertical-align: top;
        }

        .receipt-table .item-name {
            width: 70%;
        }

        .receipt-table .item-price {
            width: 30%;
            text-align: right;
        }

        .receipt-totals {
            border-top: 0.5px dashed #333;
            padding-top: 2px;
            margin-top: 0px;
            font-size: 12px;
        }

        .receipt-totals .total-row {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
        }

        .receipt-totals .grand-total {
            font-weight: bold;
            font-size: 14px;
            border-top: 1px solid #333;
            padding-top: 5px;
        }

        .receipt-footer {
            text-align: center;
            margin-top: 0px;
            font-size: 11px;
            border-top: 1px dashed #ccc;
            padding-top: 0px;
        }

        /* Print button styling for desktop */
        .btn-print {
            background-color: #2c3e50;
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 5px;
            font-weight: bold;
            margin: 20px auto;
            display: block;
            cursor: pointer;
        }

        .btn-print:hover {
            background-color: #1a252f;
        }

        /* Mobile-specific styles - Fit any screen */
        @media (max-width: 767px) {
            body {
                padding: 0 !important;
                margin: 0 !important;
                width: 100vw;
                height: 100vh;
                overflow: auto;
               
                background: white;
                display: block;
            }
            
            .thermal-receipt {
                max-width: 90% !important;
                width: 100% !important;
                margin: 0 !important;
                padding: 20px !important;
                border-radius: 0 !important;
                box-shadow: none !important;
                 font-weight: bold;
                min-height: 100vh;
                transform: none !important;
            }

            /* Make text more readable on mobile */
            .receipt-header h2 {
                font-size: 24px !important;
            }

            .receipt-header p {
                font-size: 14px !important;
            }

            .receipt-info,
            .receipt-table,
            .receipt-totals {
                font-size: 12px !important;
            }

            .section-heading {
                font-size: 16px !important;
                padding: 2 0 !important;
                margin: 2px 0 2px 0 !important;
            }

            .receipt-totals .grand-total {
                font-size: 16px !important;
            }

            .receipt-footer {
                font-size: 13px !important;
                padding-top: 5px !important;
                margin-top: 2px !important;
            }

            /* Larger touch targets */
            .receipt-table td {
                padding: 12px 0 !important;
            }

            .info-row {
                margin-bottom: 3px !important;
            }

            /* Mobile print button */
            .btn-print {
                position: fixed;
                bottom: 30px;
                left: 50%;
                transform: translateX(-50%);
                z-index: 1000;
                background-color: #2c3e50;
                color: white;
                border: none;
                padding: 15px 20px;
                border-radius: 10px;
                font-weight: bold;
                font-size: 18px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.3);
                margin: 0;
            }
        }

        /* PRINT-SPECIFIC STYLES - VERY STRONG TEXT FOR THERMAL PRINTER */
        @media print {
            /* Reset everything for print */
            body * {
                visibility: hidden;
                margin: 0 !important;
                padding: 0 !important;
                background: white !important;
                color: black !important;
            }
            
            /* Show only the receipt with very strong text */
            .thermal-receipt, 
            .thermal-receipt * {
                visibility: visible !important;
                background: white !important;
                color: black !important;
                font-family: "Courier New", Courier, monospace !important;
                
                /* EXTREMELY STRONG TEXT FOR THERMAL PRINTER */
                font-weight: 900 !important;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            
            /* Receipt container - fixed 80mm width */
            .thermal-receipt {
                position: absolute !important;
                left: 0 !important;
                top: 0 !important;
                width: 80mm !important;
                max-width: 80mm !important;
                min-width: 80mm !important;
                height: auto !important;
                margin: 0 !important;
                padding: 5px !important;
                transform: none !important;
                border-radius: 0 !important;
                box-shadow: none !important;
                border: none !important;
            }
            
            /* Header - extra strong */
            .receipt-header {
                border-bottom: 2px dashed #000 !important;
                padding-bottom: 2px !important;
                margin-bottom: 2px !important;
            }
            
            .receipt-header h2 {
                font-weight: 900 !important;
                font-size: 22px !important;
                margin-bottom: 2px !important;
                letter-spacing: 1.5px !important;
                text-transform: uppercase !important;
            }
            
            .receipt-header p {
                font-weight: 900 !important;
                font-size: 13px !important;
                margin: 3px 0 !important;
            }
            
            /* Info section - strong */
            .receipt-info {
                margin-bottom: 2px !important;
                font-size: 12px !important;
                font-weight: 900 !important;
            }
            
            .info-row {
                margin-bottom: 2px !important;
                font-weight: 900 !important;
            }
            
            .receipt-info .label {
                font-weight: 900 !important;
                width: 63px !important;
            }
            
            .receipt-info .value {
                font-weight: 900 !important;
            }
            
            /* Section heading - very strong */
            .section-heading {
                font-weight: 900 !important;
                font-size: 15px !important;
                margin: 1px 0 1px 0 !important;
                padding: 1px 0 !important;
                border-top: 2px dashed #000 !important;
                border-bottom: 2px dashed #000 !important;
                text-transform: uppercase !important;
            }
            
            /* Table - strong */
            .receipt-table {
                font-size: 12px !important;
                font-weight: 900 !important;
                margin-bottom: 2px !important;
            }
            
            .receipt-table tr {
                border-bottom: 1px dashed #000 !important;
            }
            
            .receipt-table td {
                padding: 3px 0 !important;
                font-weight: 900 !important;
            }
            
            .receipt-table .item-name {
                font-weight: 900 !important;
                text-transform: uppercase !important;
            }
            
            .receipt-table .item-price {
                font-weight: 900 !important;
            }
            
            /* Totals - extra strong */
            .receipt-totals {
           
                font-size: 13px !important;
                font-weight: 900 !important;
            }
            
            .receipt-totals .total-row {
                margin: 3px 0 !important;
                font-weight: 900 !important;
            }
            
            .receipt-totals .grand-total {
                font-weight: 900 !important;
                font-size: 16px !important;
                border-top: 2px solid #000 !important;
                padding-top: 1px !important;
                text-transform: uppercase !important;
            }
            
            /* Footer - strong */
            .receipt-footer {
                border-top: 1px dashed #000 !important;
                font-size: 12px !important;
                font-weight: 900 !important;
            }
            
            .receipt-footer p {
                font-weight: 900 !important;
                margin: 0px 0 !important;
            }
            
            /* Hide non-print elements */
            .no-print,
            .btn-print {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class="thermal-receipt" id="receiptPrint">
        <div class="receipt-header">
            <p><h2>D RESTAURANT</h2></p>
            <p>Email: dietcateringservices@gmail.com</p>
            <p>Viwandani, Dodoma</p>
            <p>Phone: 0716780595</p>
        </div>

        <div class="receipt-info">
            <div class="info-row">
                <div class="info-item">
                    <span class="label">Rcpt No:</span>
                    <span class="value">{{ str_pad($sale->id, 6, '0', STR_PAD_LEFT) }}</span>
                </div>
                <div class="info-item">
                    <span class="label">Waiter:</span>
                    <span class="value"> {{ $sale->waiter->username }}</span>
                </div>
            </div>
            <div class="info-row">
                <div class="info-item">
                    <span class="label">Cashier:</span>
                    <span class="value">{{ $sale->cashier->username ?? '-' }}</span>
                </div>
                <div class="info-item">
                    <span class="label">Payment:</span>
                    <span class="value">{{ $sale->payment_type }}</span>
                </div>
            </div>
            <div class="info-row">
                <div class="info-item">
                    <span class="label">Date:</span>
                    <span class="value">{{ $sale->created_at->format('d M Y') }}</span>
                </div>
                <div class="info-item">
                    <span class="label">Time:</span>
                    <span class="value">{{ $sale->created_at->format('H:i') }}</span>
                </div>
            </div>
        </div>

        <div class="section-heading">DETAILS</div>

        <table class="receipt-table">
            <tbody>
                @foreach($sale->items as $item)
                <tr>
                    <td class="item-name">{{ $loop->iteration }}. {{ $item->product->product_name }} ({{ $item->quantity }} x {{ number_format($item->product->selling_price, 0) }})</td>
                    <td class="item-price">{{ number_format($item->product->selling_price * $item->quantity, 0) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="receipt-totals">
            <div class="total-row">
                <span>Subtotal:</span>
                <span>{{ number_format($sale->subtotal, 2) }}</span>
            </div>
            <div class="total-row">
                <span>VAT(18%):</span>
                <span>{{ number_format($sale->tax, 2) }}</span>
            </div>
            <div class="total-row grand-total">
                <span>TOTAL:</span>
                <span>{{ number_format($sale->total, 2) }}</span>
            </div>
        </div>

        <div class="receipt-footer">
            <p>Thank you for dining with us!</p>
            <p>Karibu Tena!</p>
        </div>
    </div>

    <button class="btn-print no-print" onclick="window.print()">🖨️ Print Receipt</button>

    <script>
        // Mobile detection for additional optimizations
        document.addEventListener('DOMContentLoaded', function() {
            function isMobileDevice() {
                return (typeof window.orientation !== "undefined") || (navigator.userAgent.indexOf('IEMobile') !== -1);
            }
            
            if (isMobileDevice()) {
                // Add mobile-specific class for additional styling if needed
                document.body.classList.add('mobile-device');
            }
        });
    </script>
</body>
</html>