<!DOCTYPE html>
<html>
<head>
    <title>Sales Report</title>
    <style>
        /* ================== Global Styles ================== */
    body {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 50; /* thin/light */
        color: #222834; /* phoenix-body-highlight-color */
        background-color: #ffffff; /* phoenix-emphasis-bg */
        margin: 20px;
        line-height: 1.4;
    }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .filters {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #eff2f6; /* phoenix-body-highlight-bg */
            border: 1px solid #cbd0dd; /* phoenix-border-color */
        }
        h3, p {
            margin: 5px 0;
        }

        /* ================== Table Styles ================== */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 0.5px solid #3558b3ff; /* phoenix-border-color */
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #407dccff; /* phoenix-body-highlight-bg */
            color: white;
        }

        /* ================== Badge Styles ================== */
        .badge {
            text-transform: uppercase;
            padding: 2px 8px;
            border-radius: 4px;
            display: inline-block;
            font-size: 0.7em;
            font-weight: 20;
        }
        .badge-success {
            background-color: #d1f7c8ff; /* phoenix-success-bg-subtle */
            color: #23890b; /* phoenix-success-text-emphasis */
            border: 0.5px solid #1c6c09; /* phoenix-success-border-subtle */
        }
        .badge-danger {
            background-color: #facac2ff; /* phoenix-danger-bg-subtle */
            color: #cc1b00; /* phoenix-danger-text-emphasis */
            border: 0.5px solid #b81800; /* phoenix-danger-border-subtle */
        }

        /* ================== Totals Styles ================== */
        .totals {
            margin-top: 20px;
            font-weight: bold;
        }

    </style>
</head>
<body>
    <div class="header">
        <h1>D-RESTAURANT SALES REPORT</h1>
        <p>Generated on: {{ date('d-M-Y H:i:s') }}</p>
    </div>

    @if(!empty(array_filter($filters)))
    <div class="filters">
        <h3>Applied Filters:</h3>
        @if(!empty($filters['from']) && !empty($filters['to']))
            <p><strong>Date Range:</strong> {{ \Carbon\Carbon::parse($filters['from'])->format('d M Y') }} to {{ \Carbon\Carbon::parse($filters['to'])->format('d M Y') }}</p>
        @endif
        @if(!empty($filters['waiter_id']))
            @php $waiter = \App\Models\User::find($filters['waiter_id']); @endphp
            <p><strong>Waiter:</strong> {{ $waiter ? $waiter->name : 'N/A' }}</p>
        @endif
        @if(!empty($filters['cashier_id']))
            @php $cashier = \App\Models\User::find($filters['cashier_id']); @endphp
            <p><strong>Cashier:</strong> {{ $cashier ? $cashier->name : 'N/A' }}</p>
        @endif
        @if(!empty($filters['payment_type']))
            <p><strong>Payment Type:</strong> {{ $filters['payment_type'] }}</p>
        @endif
        @if(!empty($filters['status']))
            <p><strong>Status:</strong> {{ ucfirst($filters['status']) }}</p>
        @endif
        <p><strong>Total Records:</strong> {{ $sales->count() }}</p>
    </div>
    @endif

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Date</th>
                <th>Waiter</th>
                <th>Cashier</th>
                <th>Subtotal</th>
                <th>Tax</th>
                <th>Total</th>
                <th>Payment</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sales as $sale)
            <tr>
                <td>{{ $sale->id }}</td>
                <td>{{ $sale->created_at->format('d-m-Y H:i') }}</td>
                <td>{{ $sale->waiter ? $sale->waiter->name : '—' }}</td>
                <td>{{ $sale->cashier ? $sale->cashier->name : '—' }}</td>
                <td>{{ number_format($sale->subtotal) }}</td>
                <td>{{ number_format($sale->tax) }}</td>
                <td>{{ number_format($sale->total) }}</td>
                <td>{{ $sale->payment_type }}</td>
                <td>
                    <span class="badge {{ $sale->status === 'verified' ? 'badge-success' : 'badge-danger' }}">
                        {{ ucfirst($sale->status) }}
                    </span>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals">
        <p><strong>Subtotal Total:</strong> Tsh {{ number_format($totals['subtotal']) }}</p>
        <p><strong>Tax Total:</strong> Tsh {{ number_format($totals['tax']) }}</p>
        <p><strong>Grand Total:</strong> Tsh {{ number_format($totals['total']) }}</p>
    </div>
</body>
</html>
