<!DOCTYPE html>
<html lang="en-US" dir="ltr">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>D-Restaurant | Login</title>

<!-- CSRF meta tag for AJAX -->
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<!-- Favicons -->
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/img/favicons/apple-touch-icon.png')); ?>">
<link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/img/favicons/favicon-32x32.png')); ?>">
<link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/img/favicons/favicon-16x16.png')); ?>">
<link rel="shortcut icon" href="<?php echo e(asset('assets/img/favicons/favicon.ico')); ?>">

<!-- CSS -->
<link rel="stylesheet" href="<?php echo e(asset('vendors/simplebar/simplebar.min.css')); ?>">
<link href="<?php echo e(asset('assets/css/theme.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/css/user.min.css')); ?>" rel="stylesheet">

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@300;400;600;700;800;900&display=swap" rel="stylesheet">

<style>
    .user-card {
        margin-bottom: 1rem;
        cursor: pointer;
    }
    @media (max-width: 992px) {
        .col-lg-6.position-relative {
            display: block !important;
        }
    }
    .password-toggle {
        position: absolute;
        top: 50%;
        right: 0.75rem;
        transform: translateY(-50%);
        background: none;
        border: none;
        cursor: pointer;
        font-size: 1rem;
        color: #6c757d;
    }
    .form-icon-container {
        position: relative;
    }

    /* Loader Styles */
    .loader-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        visibility: hidden;
        opacity: 0;
        transition: opacity 0.3s ease, visibility 0.3s ease;
    }

    .loader-overlay.active {
        visibility: visible;
        opacity: 1;
    }

    .loader {
        border: 5px solid #f3f3f3;
        border-top: 5px solid #007bff;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>
</head>

<body>
<main class="main" id="top">
<div class="row vh-100 g-0">

    <!-- LEFT SIDE: User Quick-Select Badge Cards -->
    <div class="col-lg-6 col-md-6 d-md-block d-lg-block position-relative">
        <div class="d-flex align-items-center justify-content-center h-100">
            <div class="row g-3 w-100">
                <?php
                    $sortedUsers = $users->sortBy('username');

                    $badgeClasses = [
                        'badge-phoenix-primary',
                        'badge-phoenix-secondary',
                        'badge-phoenix-success',
                        'badge-phoenix-info',
                        'badge-phoenix-warning',
                        'badge-phoenix-danger'
                    ];
                    $badgeCount = count($badgeClasses);
                    $index = 0;

                    $roles = [
                        2 => 'Cashier',
                        3 => 'Waiter'
                    ];
                ?>

                <?php $__currentLoopData = $sortedUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $badgeClass = $badgeClasses[$index % $badgeCount];
                        $index++;
                        $roleName = $roles[$user->is_role] ?? 'User';
                    ?>
                    <div class="col-6 col-sm-6 col-xl-4">
                        <div class="badge badge-phoenix <?php echo e($badgeClass); ?> w-100 h-100 user-card text-center d-flex flex-column justify-content-center align-items-center p-3" data-username="<?php echo e($user->username); ?>">
                            <h5 class="mb-1 text-truncate w-100">
                                <i class="fas fa-user-circle me-2"></i><?php echo e($user->username); ?>

                            </h5>
<span class="fs-7 mt-1 text-truncate w-100 fw-light" style="text-transform: none;">
    <?php echo e(ucfirst(strtolower($roleName))); ?>

</span>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- RIGHT SIDE: Login Form -->
    <div class="col-lg-6 col-md-6">
        <div class="row flex-center h-100 g-0 px-4 px-sm-0">
            <div class="col col-sm-6 col-lg-7 col-xl-6">
                <a class="d-flex flex-center text-decoration-none mb-4" href="/">
                    <div class="d-flex align-items-center">
                        <h5 class="logo-text ms-2 d-none d-sm-block">D-Restaurant POS</h5>
                    </div>
                </a>
                <div class="text-center mb-7">
                    <h3 class="text-body-highlight">Login</h3>
                    <p class="text-body-tertiary">Get access to your account</p>
                    <hr class="bg-body-secondary mt-5 mb-4" />
                    <?php echo $__env->make('auth.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <form id="loginForm" action="<?php echo e(url('login_post')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3 text-start">
                            <label class="form-label" for="username">Username</label>
                            <div class="form-icon-container">
                                <input class="form-control form-icon-input" id="username" type="text" name="username" required placeholder="denis" />
                                <span class="fas fa-user text-body fs-9 form-icon"></span>
                            </div>
                        </div>

                        <div class="mb-3 text-start">
                            <label class="form-label" for="password">Password</label>
                            <div class="form-icon-container">
                                <input class="form-control form-icon-input pe-6" id="password" name="password" type="password" required placeholder="Password" />
                                <span class="fas fa-key text-body fs-9 form-icon"></span>
                                <button type="button" class="password-toggle" id="togglePassword">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 mb-3" id="signInButton">Sign In</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
</main>

<!-- Loader Overlay -->
<div class="loader-overlay" id="loader">
    <div class="loader"></div>
</div>

<!-- JAVASCRIPTS -->
<script src="<?php echo e(asset('vendors/popper/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/bootstrap/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/fontawesome/all.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/phoenix.js')); ?>"></script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const usernameField = document.getElementById('username');
    const passwordField = document.getElementById('password');
    const toggleBtn = document.getElementById('togglePassword');
    const loginForm = document.getElementById('loginForm');
    const loader = document.getElementById('loader');

    // Autofill username on badge click
    document.querySelectorAll('.user-card').forEach(card => {
        card.addEventListener('click', () => {
            usernameField.value = card.dataset.username;
            passwordField.focus();
        });
    });

    // Password toggle
    toggleBtn.addEventListener('click', () => {
        const icon = toggleBtn.querySelector('i');
        if(passwordField.type === 'password'){
            passwordField.type = 'text';
            icon.classList.replace('fa-eye', 'fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.replace('fa-eye-slash', 'fa-eye');
        }
    });

    // Show loader when form is submitted
    loginForm.addEventListener('submit', function() {
        loader.classList.add('active');
        loginForm.querySelector('button[type="submit"]').disabled = true;
    });

    // Refresh CSRF token every 60 seconds
    setInterval(() => {
        fetch("<?php echo e(url('refresh-csrf')); ?>", {
            method: "GET",
            headers: {
                "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                "Accept": "application/json"
            }
        })
        .then(response => response.json())
        .then(data => {
            if(data.csrf_token) {
                document.querySelector('meta[name="csrf-token"]').setAttribute('content', data.csrf_token);
                const csrfInput = document.querySelector('input[name="_token"]');
                if(csrfInput) csrfInput.value = data.csrf_token;
                console.log('CSRF token refreshed.');
            }
        })
        .catch(err => console.error('Error refreshing CSRF:', err));
    }, 60000);
});
</script>
</body>
</html>
<?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/auth/login.blade.php ENDPATH**/ ?>