<?php $__env->startSection('title', 'User Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">
        <span class="text-muted fw-light">Admin /</span> Users
    </h4>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">User List</h5>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">
                <i class="fas fa-plus me-2"></i> Add User
            </button>
        </div>

        
        <div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form id="addUserForm">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h5 class="modal-title">Add User</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" name="name" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Role</label>
                                <select name="is_role" class="form-select" required>
                                    <option value="2">Cashier</option>
                                    <option value="3">Waiter</option>
                                    <option value="6">Validator</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select" required>
                                    <option value="1" selected>Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save User</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="modal fade" id="editUserModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form id="editUserForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="user_id" id="editUserId">
                        <div class="modal-header">
                            <h5 class="modal-title">Edit User</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" name="name" id="editUserName" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" id="editUserEmail" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Password (leave blank to keep current)</label>
                                <input type="password" name="password" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Role</label>
                                <select name="is_role" id="editUserRole" class="form-select" required>
                                    <option value="2">Cashier</option>
                                    <option value="3">Waiter</option>
                                    <option value="6">Validator</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" id="editUserStatus" class="form-select" required>
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update User</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="modal fade" id="deleteUserModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Confirm Delete</h5>
                        <button class="btn btn-close" type="button" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete user <b id="deleteUserName"></b>?
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary" id="confirmDeleteUserBtn">Delete</button>
                        <button class="btn btn-outline-primary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" id="userTable">
                    <thead>
                        <tr>
                            <th class="text-center">#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Updated At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index:2000"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {

    const tableBody = $('#userTable tbody');
    let deleteUserId = null, deleteUserName = null;

    function formatDate(dateString) {
        if (!dateString) return "—";
        const date = new Date(dateString);
        return isNaN(date) ? "—" : date.toLocaleString();
    }

    function loadUsers() {
        $.ajax({
            url: "<?php echo e(route('users.index')); ?>",
            type: "GET",
            dataType: "json",
            success: function(users) {
                tableBody.empty();
                users.forEach((user,index) => {
                    const role = user.is_role == 2 ? 'Cashier' : 'Waiter';
                    const status = user.status == 1 
                        ? '<span class="badge bg-success">Active</span>' 
                        : '<span class="badge bg-danger">Inactive</span>';
                    tableBody.append(`
                        <tr>
                            <td class="text-center">${index+1}</td>
                            <td>${user.name}</td>
                            <td>${user.email}</td>
                            <td>${role}</td>
                            <td>${status}</td>
                            <td>${formatDate(user.created_at)}</td>
                            <td>${formatDate(user.updated_at)}</td>
                            <td>
                                <button class="btn btn-sm btn-warning edit-btn" 
                                    data-id="${user.id}" 
                                    data-name="${user.name}" 
                                    data-email="${user.email}" 
                                    data-role="${user.is_role}" 
                                    data-status="${user.status}">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger delete-btn" 
                                    data-id="${user.id}" 
                                    data-name="${user.name}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    `);
                });

                if ($.fn.DataTable.isDataTable('#userTable')) {
                    $('#userTable').DataTable().destroy();
                }
                $('#userTable').DataTable({ pageLength:10, order:[[0,'asc']], responsive:true });
            }
        });
    }

    loadUsers();

    function showToast(message,type='success') {
        const toastHTML = `
            <div class="toast show text-${type}" role="alert" data-bs-delay="5000">
                <div class="toast-header">
                    <strong class="me-auto">${type==='success'?'Success':'Error'}</strong>
                    <small>Just now</small>
                    <button class="btn ms-2 p-0" type="button" data-bs-dismiss="toast">
                        <span class="uil uil-times"></span>
                    </button>
                </div>
                <div class="toast-body">${message}</div>
            </div>
        `;
        const $toast = $(toastHTML);
        $('.toast-container').append($toast);
        new bootstrap.Toast($toast[0]).show();
    }

    // Add User
    $('#addUserForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: "<?php echo e(route('users.store')); ?>",
            type: "POST",
            data: $(this).serialize(),
            success: function(response){
                $('#addUserModal').modal('hide');
                $('#addUserForm')[0].reset();
                location.reload();
                showToast(`User <b>${response.user.name}</b> added successfully`);
            },
            error: function(xhr){
    console.error(xhr.responseText);
    showToast('Error adding user','danger');
}

        });
    });

    // Open Edit Modal
    $(document).on('click','.edit-btn',function(){
        $('#editUserId').val($(this).data('id'));
        $('#editUserName').val($(this).data('name'));
        $('#editUserEmail').val($(this).data('email'));
        $('#editUserRole').val($(this).data('role'));
        $('#editUserStatus').val($(this).data('status'));
        $('#editUserModal').modal('show');
    });

    // Update User
    $('#editUserForm').on('submit',function(e){
        e.preventDefault();
        const id = $('#editUserId').val();
        $.ajax({
            url: `/users/update/${id}`,
            type: "PUT",
            data: $(this).serialize(),
            success: function(response){
                $('#editUserModal').modal('hide');
                location.reload();
                showToast(`User <b>${response.user.name}</b> updated successfully`);
            },
            error:function(){ showToast('Error updating user','danger'); }
        });
    });

    // Delete User
    $(document).on('click','.delete-btn',function(){
        deleteUserId = $(this).data('id');
        deleteUserName = $(this).data('name');
        $('#deleteUserName').text(deleteUserName);
        $('#deleteUserModal').modal('show');
    });

    $('#confirmDeleteUserBtn').on('click',function(){
        if(!deleteUserId) return;
        $.ajax({
            url: `/users/delete/${deleteUserId}`,
            type: "DELETE",
            data: { _token: "<?php echo e(csrf_token()); ?>" },
            success:function(response){
                $('#deleteUserModal').modal('hide');
                location.reload();
                showToast(`User <b>${response.user.name}</b> deleted successfully`);
            },
            error:function(){ showToast('Error deleting user','danger'); }
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/users/index.blade.php ENDPATH**/ ?>