<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payroll Report Week <?php echo e($week); ?> from <?php echo e($weekStart->format('j M')); ?> to <?php echo e($weekEnd->format('j M')); ?> <?php echo e($year); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header .subtitle {
            color: #666;
            font-size: 14px;
        }
        .summary-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 8px 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .total-row {
            background-color: #e9ecef;
            font-weight: bold;
        }
        .grand-total-row {
            background-color: #343a40;
            color: white;
            font-weight: bold;
            font-size: 14px;
        }
        .eligible {
            color: #28a745;
            font-weight: bold;
        }
        .not-eligible {
            color: #6c757d;
        }
        .special-payment {
            color: #17a2b8;
            font-weight: bold;
            font-style: italic;
        }
        .monthly-salary {
            color: #6f42c1;
            font-weight: bold;
            font-style: italic;
        }
        .section-title {
            background-color: #343a40;
            color: white;
            padding: 10px;
            margin: 20px 0 10px 0;
            font-size: 16px;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            color: #0a0a0aff;
            font-size: 10px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .policy-note {
            background: #fff3cd;
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
            border-left: 4px solid #ffc107;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>RESTAURANT WAITERS' PAYROLL REPORT</h1>
        <div class="subtitle">
            Week <?php echo e($week); ?> of <?php echo e($year); ?> (<?php echo e($weekStart->format('M j, Y')); ?> - <?php echo e($weekEnd->format('M j, Y')); ?>)
        </div>
        <div class="subtitle">Generated on: <?php echo e($exportTime); ?></div>
    </div>

    <div class="summary-info">
        <strong>Standard Payroll Policy:</strong> 4% of <strong>daily</strong> sales, rounded to the nearest 1,000 TZS  
        (Minimum 100,000 TZS daily sales required).  
        Weekly payment = <strong>sum of daily payments</strong>.
        
        <div class="policy-note">
            <strong>Special Arrangements:</strong><br>
            • <strong>Aisha Juma:</strong> Fixed 10,000 TZS per day worked<br>
            • <strong>Tumaini George:</strong> Paid fixed monthly salary (excluded from weekly payroll)
        </div>
    </div>

    <!-- Weekly Summary -->
    <div class="section-title">WEEKLY PAYROLL SUMMARY</div>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Waiter Name</th>
                <th>Total Weekly Sales (TZS)</th>
                <th>Weekly Payment (TZS)</th>
                <th>Eligible Days</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $totalWeeklyPayment = 0;
            ?>
            <?php $__currentLoopData = $waiters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $eligibleDays = count(array_filter($waiter['daily'], fn($day) => $day['is_eligible']));
                $isAisha = strtolower($waiter['name']) === 'aisha juma';
                $isTumaini = strtolower($waiter['name']) === 'tumaini george';
                
                // Add to total only if not Tumaini (monthly salary)
                if (!$isTumaini) {
                    $totalWeeklyPayment += $waiter['weekly_total_payment'];
                }
            ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($waiter['name']); ?></td>
                <td style="text-align:right;"><?php echo e(number_format($waiter['weekly_total_sales'], 0)); ?></td>
                <td style="text-align:right;" class="<?php echo e($isAisha ? 'special-payment' : ($isTumaini ? 'monthly-salary' : ($waiter['weekly_total_payment'] > 0 ? 'eligible' : 'not-eligible'))); ?>">
                    <?php if($isAisha): ?>
                        <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?>

                    <?php elseif($isTumaini): ?>
                        PAID MONTHLY
                    <?php else: ?>
                        <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?>

                    <?php endif; ?>
                </td>
                <td style="text-align:center;">
                    <?php if($isAisha): ?>
                        <?php echo e($waiter['days_worked'] ?? 0); ?>

                    <?php else: ?>
                        <?php echo e($eligibleDays); ?>

                    <?php endif; ?>
                </td>
                <td style="text-align:center;">
                    <?php if($isAisha): ?>
                        <span style="color: #17a2b8;">FIXED DAILY</span>
                    <?php elseif($isTumaini): ?>
                        <span style="color: #6f42c1;">MONTHLY SALARY</span>
                    <?php else: ?>
                        <?php echo e($waiter['weekly_total_payment'] > 0 ? 'PAYABLE' : 'NO PAYMENT'); ?>

                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <!-- Total Row -->
            <tr class="grand-total-row">
                <td colspan="3" style="text-align: right;"><strong>TOTAL WEEKLY PAYMENT:</strong></td>
                <td style="text-align:right; color: white;">
                    <strong><?php echo e(number_format($totalWeeklyPayment, 0)); ?> TZS</strong>
                </td>
                <td colspan="2" style="text-align: center; color: white;">
                    <strong>AMOUNT TO BE PAID</strong>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Daily Breakdown -->
    <?php $__currentLoopData = $waiters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $isAisha = strtolower($waiter['name']) === 'aisha juma';
        $isTumaini = strtolower($waiter['name']) === 'tumaini george';
    ?>
    
    <div class="section-title">
        <?php echo e(strtoupper($waiter['name'])); ?> - DAILY BREAKDOWN
        <?php if($isAisha): ?>
            <span style="font-size: 12px; float: right;">(FIXED 10,000 TZS PER DAY)</span>
        <?php elseif($isTumaini): ?>
            <span style="font-size: 12px; float: right;">(MONTHLY SALARY)</span>
        <?php endif; ?>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Day</th>
                <th>Date</th>
                <th>Sales Count</th>
                <th>Total Sales (TZS)</th>
                <th>4% Value (TZS)</th>
                <th>Payment (TZS)</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $waiter['daily']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dayData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $fourPercentValue = $dayData['total_amount'] * 0.04;
                $formattedDate = \Carbon\Carbon::parse($dayData['date'])->format('j M');
            ?>
            <tr>
                <td><strong><?php echo e($dayData['day_name']); ?></strong></td>
                <td><?php echo e($formattedDate); ?></td>
                <td style="text-align:center;"><?php echo e($dayData['sales_count']); ?></td>
                <td style="text-align:right;"><?php echo e(number_format($dayData['total_amount'], 0)); ?></td>
                <td style="text-align:right;">
                    <?php if($isAisha || $isTumaini): ?>
                        -
                    <?php else: ?>
                        <?php echo e(number_format($fourPercentValue, 0)); ?>

                    <?php endif; ?>
                </td>
                <td style="text-align:right;" class="<?php echo e($isAisha ? 'special-payment' : ($isTumaini ? 'monthly-salary' : ($dayData['is_eligible'] ? 'eligible' : 'not-eligible'))); ?>">
                    <?php if($isAisha): ?>
                        <?php echo e(number_format($dayData['payment'], 0)); ?>

                    <?php elseif($isTumaini): ?>
                        MONTHLY
                    <?php else: ?>
                        <?php echo e(number_format($dayData['payment'], 0)); ?>

                    <?php endif; ?>
                </td>
                <td style="text-align:center;">
                    <?php if($isAisha): ?>
                        <span style="color: #17a2b8;">FIXED RATE</span>
                    <?php elseif($isTumaini): ?>
                        <span style="color: #6f42c1;">MONTHLY</span>
                    <?php else: ?>
                        <?php echo e($dayData['is_eligible'] ? 'ELIGIBLE' : 'NOT ELIGIBLE'); ?>

                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="3"><strong>WEEKLY TOTALS</strong></td>
                <td style="text-align:right;"><strong><?php echo e(number_format($waiter['weekly_total_sales'], 0)); ?></strong></td>
                <td style="text-align:right;"><strong>-</strong></td>
                <td style="text-align:right;" class="<?php echo e($isAisha ? 'special-payment' : ($isTumaini ? 'monthly-salary' : 'eligible')); ?>">
                    <strong>
                        <?php if($isAisha): ?>
                            <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?>

                        <?php elseif($isTumaini): ?>
                            PAID MONTHLY
                        <?php else: ?>
                            <?php echo e(number_format($waiter['weekly_total_payment'], 0)); ?>

                        <?php endif; ?>
                    </strong>
                </td>
                <td></td>
            </tr>
        </tfoot>
    </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="footer">
        <p><strong>Payment Formulas:</strong></p>
        <p>• <strong>Standard Waiters:</strong> IF(Sales ≥ 100,000 → ROUND(Sales × 4%, -3), ELSE 0)</p>
        <p>• <strong>Aisha Juma:</strong> Fixed 10,000 TZS per day worked</p>
        <p>• <strong>Tumaini George:</strong> Fixed monthly salary (excluded from weekly payroll)</p>
        <p>Weekly Payment = SUM of all daily payments (except Tumaini George - monthly salary).</p>
        <p>This is a system-generated report.</p>
    </div>
</body>
</html><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/admin/payroll/export.blade.php ENDPATH**/ ?>