<?php echo $__env->make('includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- ===============================================-->
<!--    Document Title-->
<!-- ===============================================-->
<title>D-Restaurant | Admin</title>

<script>
  var phoenixIsRTL = window.config.config.phoenixIsRTL;
  if (phoenixIsRTL) {
    var linkDefault = document.getElementById('style-default');
    var userLinkDefault = document.getElementById('user-style-default');
    linkDefault.setAttribute('disabled', true);
    userLinkDefault.setAttribute('disabled', true);
    document.querySelector('html').setAttribute('dir', 'rtl');
  } else {
    var linkRTL = document.getElementById('style-rtl');
    var userLinkRTL = document.getElementById('user-style-rtl');
    linkRTL.setAttribute('disabled', true);
    userLinkRTL.setAttribute('disabled', true);
  }
</script>
<link href="vendors/leaflet/leaflet.css" rel="stylesheet">
<link href="vendors/leaflet.markercluster/MarkerCluster.css" rel="stylesheet">
<link href="vendors/leaflet.markercluster/MarkerCluster.Default.css" rel="stylesheet">
<meta name="viewport" content="width=device-width, initial-scale=0.7">

</head>

<body>
<!-- ===============================================-->
<!--    Main Content-->
<!-- ===============================================-->
<main class="main" id="top">

<?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="content">
  <div class="pb-5">
    <!-- Top Section: Current Stats and Daily Charts -->
<div class="mb-8">
    <h2 class="mb-2">
        <?php
            $roleName = match(Auth::user()->is_role) {
                1 => 'Admin',
                2 => 'Cashier',
                3 => 'Waiter',
                default => 'User',
            };
        ?>
        <?php echo e($roleName); ?> Dashboard
    </h2>
</div>


    <!-- Quick Stats Row -->
    <div class="row g-3 mb-6">
      <div class="col-12 col-sm-6 col-xl-3">
        <div class="card">
          <div class="card-body">
            <div class="d-flex align-items-center">
              <div class="flex-1">
                <h5 class="mb-1">Today's Sales</h5>
                <h2 class="mb-0 text-primary">Tsh. <?php echo e(number_format($stats['today_sales'] ?? 0, 2)); ?></h2>
                <p class="fs-9 mb-0 <?php echo e(($stats['sales_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger'); ?>">
                  <span class="fas fa-arrow-<?php echo e(($stats['sales_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> me-1"></span>
                  <?php echo e(number_format($stats['sales_growth'] ?? 0, 1)); ?>% from yesterday
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-xl-3">
        <div class="card">
          <div class="card-body">
            <div class="d-flex align-items-center">
                <div class="flex-1">
                    <h5 class="mb-1">Today's Sold Items</h5>
                    <h2 class="mb-0 text-info"><?php echo e($stats['today_items_sold'] ?? 0); ?></h2>
                    <p class="fs-9 mb-0 <?php echo e(($stats['items_growth'] ?? 0) >= 0 ? 'text-success' : 'text-danger'); ?>">
                        <span class="fas fa-arrow-<?php echo e(($stats['items_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> me-1"></span>
                        <?php echo e(number_format($stats['items_growth'] ?? 0, 1)); ?>% from yesterday
                    </p>
                </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-xl-3">
        <div class="card">
          <div class="card-body">
            <div class="d-flex align-items-center">
              <div class="flex-1">
                <h5 class="mb-1">Verified Sales</h5>
                <h2 class="mb-0 text-success"><?php echo e($salesStatus['verified_count'] ?? 0); ?></h2>
                <p class="fs-9 mb-0"><?php echo e($salesStatus['verified'] ?? 0); ?>% of total</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-xl-3">
        <div class="card">
          <div class="card-body">
            <div class="d-flex align-items-center">
              <div class="flex-1">
                <h5 class="mb-1">Pending Sales</h5>
                <h2 class="mb-0 text-warning"><?php echo e($salesStatus['pending_count'] ?? 0); ?></h2>
                <p class="fs-9 mb-0"><?php echo e($salesStatus['pending'] ?? 0); ?>% of total</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Current Time Period Charts -->
    <div class="row g-4">
      <!-- Left Column: Main Comparison Charts -->
      <div class="col-12 col-xxl-8">
        <!-- Today vs Yesterday -->
        <div class="card mb-4">
          <div class="card-header">
            <h5 class="mb-0">Today vs Yesterday Sales</h5>
            <small class="text-body-tertiary">Hourly comparison (7:00 - 22:00)</small>
          </div>
          <div class="card-body">
            <div class="echart-today-yesterday" style="height: 350px;"></div>
          </div>
        </div>

        <!-- This Week vs Last Week -->
        <div class="card">
          <div class="card-header">
            <h5 class="mb-0">This Week vs Last Week</h5>
            <small class="text-body-tertiary">Daily comparison</small>
          </div>
          <div class="card-body">
            <div class="echart-week-comparison" style="height: 350px;"></div>
          </div>
        </div>
      </div>

      <!-- Right Column: Small Charts and Status -->
      <div class="col-12 col-xxl-4">
        <div class="row g-3">
<div class="col-12 col-md-12 col-xxl-12">
  <div class="card h-100">
    <div class="card-body d-flex flex-column">
      <div class="d-flex justify-content-between">
        <div>
          <h5 class="mb-0">Sales Status</h5> <!-- reduced mb-2 → mb-1 -->
          <h6 class="text-body-tertiary mb-1">Pending vs Verified</h6> <!-- add mb-1 to reduce spacing -->
        </div>
      </div>
      <div class="d-flex justify-content-center pt-1 flex-1"> <!-- reduced pt-3 → pt-1 -->
        <div class="echarts-sales-status-chart" style="height:250px;width:100%;"></div>
      </div>
      <div class="mt-0"> <!-- reduced mt-3 → mt-2 -->
        <div class="d-flex align-items-center mb-2">
          <div class="bullet-item bg-success me-2"></div>
          <h6 class="text-body fw-semibold flex-1 mb-0">Verified Sales</h6>
          <h6 class="text-body fw-semibold mb-0" id="verified-percentage"><?php echo e($salesStatus['verified'] ?? 0); ?>%</h6>
        </div>
        <div class="d-flex align-items-center">
          <div class="bullet-item bg-warning me-2"></div>
          <h6 class="text-body fw-semibold flex-1 mb-0">Pending Sales</h6>
          <h6 class="text-body fw-semibold mb-0" id="pending-percentage"><?php echo e($salesStatus['pending'] ?? 0); ?>%</h6>
        </div>
      </div>
    </div>
  </div>
</div>


          <!-- Waiter Performance -->
<div class="col-12 col-xxl-12">
    <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <h5 class="mb-1">Waiter Performance</h5>
                <h6 class="text-body-tertiary">Today vs Yesterday Comparison</h6>
            </div>
            <div class="badge bg-primary rounded-pill"><?php echo e(count($waiterPerformance)); ?> Waiters</div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive" style="max-height: 515px; overflow-y: auto;">
                <table class="table table-hover table-bsaleless mb-0">
                    <thead class="bg-body-secondary sticky-top">
                        <tr>
                            <th class="ps-4 small fw-semibold text-body-tertiary">Waiter</th>
                            <th class="text-center small fw-semibold text-body-tertiary">Today</th>
                            <th class="text-center small fw-semibold text-body-tertiary">Yesterday</th>
                            <th class="text-end pe-4 small fw-semibold text-body-tertiary">Growth</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $waiterPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $waiter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="bsale-bottom">
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-s me-3">
                                        <div class="avatar-name rounded-circle bg-primary">
                                            <span class="text-white fs-9"><?php echo e(substr($waiter['waiter_name'], 0, 1)); ?></span>
                                        </div>
                                    </div>
                                    <div>
                                        <h6 class="mb-0 fw-semibold"><?php echo e($waiter['waiter_name']); ?></h6>
                                        <small class="text-muted">Avg: Tsh <?php echo e(number_format($waiter['average_sale_value'], 0)); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="d-flex flex-column">
                                    <span class="fw-bold text-success"><?php echo e($waiter['today_sales_count']); ?> sales</span>
                                    <small class="text-muted"><?php echo e($waiter['today_items_sold']); ?> items</small>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format($waiter['today_total_amount'], 0)); ?></span>
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="d-flex flex-column">
                                    <span class="fw-bold text-body"><?php echo e($waiter['yesterday_sales_count']); ?> sales</span>
                                    <small class="text-muted"><?php echo e($waiter['yesterday_items_sold']); ?> items</small>
                                    <span class="fw-semibold">Tsh <?php echo e(number_format($waiter['yesterday_total_amount'], 0)); ?></span>
                                </div>
                            </td>
                            <td class="text-end pe-4">
                                <div class="d-flex flex-column align-items-end">
                                    <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e($waiter['sales_growth'] >= 0 ? 'success' : 'danger'); ?>">
                                        <span class="badge-label"><?php echo e(number_format($waiter['sales_growth'], 1)); ?>%</span>
                                        <span class="ms-1 fas fa-arrow-<?php echo e($waiter['sales_growth'] >= 0 ? 'up' : 'down'); ?>"></span>
                                    </span>
                                    <small class="text-muted mt-1">Sales</small>
                                    
                                    <span class="badge badge-phoenix fs-10 badge-phoenix-<?php echo e($waiter['amount_growth'] >= 0 ? 'success' : 'danger'); ?> mt-2">
                                        <span class="badge-label"><?php echo e(number_format($waiter['amount_growth'], 1)); ?>%</span>
                                        <span class="ms-1 fas fa-arrow-<?php echo e($waiter['amount_growth'] >= 0 ? 'up' : 'down'); ?>"></span>
                                    </span>
                                    <small class="text-muted mt-1">Amount</small>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center py-5">
                                <i class="fas fa-users text-muted fa-2x mb-3"></i>
                                <p class="text-muted mb-0">No waiter data available for today</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
    </div>
    </div>
  <!-- Current Time Period Charts -->
    <div class="container>
      <!-- Left Column: Main Comparison Charts -->
      <div class="col-12 col-xxl-12">


      <!-- Quick Stats: Pending Sales by Waiter -->
<?php if(isset($waiterStats) && $waiterStats->count() > 0): ?>
<div class="card mb-4">
  <div class="card-header d-flex justify-content-between align-items-center">
    <h5 class="mb-0">Pending Sales Summary by Waiter</h5>
    <small class="text-muted">Overview of all pending sales totals</small>
  </div>
  <div class="card-body">
    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle mb-0">
        <thead>
          <tr>
            <th>Waiter Name</th>
            <th class="text-end">Total Pending Amount (TZS)</th>
            <th class="text-center">Pending Sales Count</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $waiterStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td>
              <span class="fw-semibold text-body">
                <?php echo e($stat->waiter->name ?? 'Walk-in Customer'); ?>

              </span>
            </td>
            <td class="text-end text-primary fw-semibold">
              <?php echo e(number_format($stat->pending_total, 2)); ?>

            </td>
            <td class="text-center text-warning fw-bold">
              <?php echo e($stat->pending_count); ?>

            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php endif; ?>

    <!-- Sales Table -->
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis pt-7 bsale-y mt-6">
      <div data-list='{"valueNames":["product","customer","rating","review","time"],"page":6}'>
        <div class="row align-items-end justify-content-between pb-5 g-3">
          <div class="col-auto">
            <h3>Recent Sales</h3>
            <p class="text-body-tertiary lh-sm mb-0">Latest 50 transactions</p>
          </div>
          <div class="col-12 col-md-auto">
            <div class="row g-2 gy-3">
              <div class="col-auto flex-1">
                <div class="search-box">
                  <form class="position-relative">
                    <input class="form-control search-input search form-control-sm" type="search" placeholder="Search sales..." aria-label="Search" />
                    <span class="fas fa-search search-box-icon"></span>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="table-responsive mx-n1 px-1 scrollbar">
<table class="table fs-9 mb-0 bsale-top bsale-translucent">
  <thead>
    <tr>
      <th class="white-space-nowrap fs-9 ps-0 align-middle">
        <div class="form-check mb-0 fs-8">
          <input class="form-check-input" id="checkbox-bulk-sales-select" type="checkbox" data-bulk-select='{"body":"table-latest-sales-body"}' />
        </div>
      </th>
      <th class="sort white-space-nowrap align-middle" scope="col" data-sort="id">ID</th>
      <th class="sort align-middle" scope="col" data-sort="customer" style="min-width:200px;">CUSTOMER/Waiter</th>
      <th class="sort align-middle" scope="col" data-sort="cashier" style="min-width:150px;">CASHIER</th>
      <th class="sort align-middle" scope="col" data-sort="amount" style="min-width:120px;">AMOUNT</th>
      <th class="sort align-middle" scope="col" data-sort="payment" style="min-width:130px;">PAYMENT</th>
      <th class="sort align-middle" scope="col" style="max-width:200px;" data-sort="items">ITEMS</th>
      <th class="sort text-start ps-5 align-middle" scope="col" data-sort="status">STATUS</th>
      <th class="sort text-end align-middle" scope="col" data-sort="time">TIME</th>
      <th class="sort text-center align-middle" scope="col">ACTIONS</th>
    </tr>
  </thead>
  <tbody class="list" id="table-latest-sales-body">
    <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr class="hover-actions-trigger btn-reveal-trigger position-static">
      <td class="fs-9 align-middle ps-0">
        <div class="form-check mb-0 fs-8">
          <input class="form-check-input" type="checkbox" data-bulk-select-row='{"id":"<?php echo e($sale->id); ?>","customer":"<?php echo e($sale->waiter->name ?? 'N/A'); ?>","amount":"<?php echo e(number_format($sale->total, 2)); ?>","status":"<?php echo e($sale->status); ?>","time":"<?php echo e($sale->created_at->diffForHumans()); ?>"}' />
        </div>
      </td>
      <td class="align-middle id white-space-nowrap">
        <h6 class="mb-0 text-body-highlight">#<?php echo e($sale->id); ?></h6>
      </td>
      <td class="align-middle customer white-space-nowrap">
        <a class="d-flex align-items-center text-body" href="#!">
          <div class="avatar avatar-l">
            <?php if($sale->waiter && $sale->waiter->avatar): ?>
              <img class="rounded-circle" src="<?php echo e(asset($sale->waiter->avatar)); ?>" alt="" />
            <?php else: ?>
              <div class="avatar-name rounded-circle">
                <span><?php echo e(substr($sale->waiter->name ?? 'N', 0, 1)); ?></span>
              </div>
            <?php endif; ?>
          </div>
          <h6 class="mb-0 ms-3 text-body"><?php echo e($sale->waiter->name ?? 'Walk-in Customer'); ?></h6>
        </a>
      </td>
      <td class="align-middle cashier white-space-nowrap">
        <span class="text-body"><?php echo e($sale->cashier->name ?? 'System'); ?></span>
      </td>
      <td class="align-middle amount white-space-nowrap">
        <h6 class="mb-0 text-body-highlight">Tsh. <?php echo e(number_format($sale->total, 2)); ?></h6>
      </td>
      <td class="align-middle payment white-space-nowrap">
        <span class="badge fs-10 badge-phoenix 
          <?php if($sale->payment_type === 'Cash'): ?> badge-phoenix-primary
          <?php elseif($sale->payment_type === 'Mobile'): ?> badge-phoenix-info
          <?php else: ?> badge-phoenix-secondary <?php endif; ?>">
          <span class="badge-label"><?php echo e($sale->payment_type); ?></span>
        </span>
      </td>
      <td class="align-middle items" style="min-width:200px;">
        <p class="fs-9 fw-semibold text-body-highlight mb-0">
          <?php echo e($sale->items->count()); ?> items
          <?php if($sale->items->count() > 0): ?>
          <br><small class="text-muted"><?php echo e($sale->items->first()->product->name ?? ''); ?><?php echo e($sale->items->count() > 1 ? ' +' . ($sale->items->count() - 1) . ' more' : ''); ?></small>
          <?php endif; ?>
        </p>
      </td>
      <td class="align-middle text-start ps-5 status">
        <?php if($sale->status === 'verified'): ?>
          <span class="badge badge-phoenix fs-10 badge-phoenix-success">
            <span class="badge-label">Verified</span>
            <span class="ms-1" data-feather="check" style="height:12.8px;width:12.8px;"></span>
          </span>
        <?php else: ?>
          <span class="badge badge-phoenix fs-10 badge-phoenix-warning">
            <span class="badge-label">Pending</span>
            <span class="ms-1" data-feather="clock" style="height:12.8px;width:12.8px;"></span>
          </span>
        <?php endif; ?>
      </td>
      <td class="align-middle text-end time white-space-nowrap">
        <div>
          <h6 class="text-body-highlight mb-0"><?php echo e($sale->created_at->format('H:i')); ?></h6>
          <small class="text-muted"><?php echo e($sale->created_at->format('M d, Y')); ?></small>
        </div>
      </td>
      <td class="align-middle text-center">
        <div class="d-flex justify-content-center gap-2">
          <?php if($sale->status === 'pending'): ?>
            <button class="btn btn-sm btn-phoenix-success verify-sale" 
                    data-sale-id="<?php echo e($sale->id); ?>"
                    title="Verify sale">
              <span class="fas fa-check fs-10"></span>
            </button>
          <?php endif; ?>
          <a href="<?php echo e(url('sales/receipt/'.$sale->id)); ?>" 
             class="btn btn-sm btn-phoenix-primary"
             target="_blank"
             title="View Receipt">
            <span class="fas fa-eye fs-10"></span>
          </a>
        </div>
      </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </tbody>
</table>

        </div>
        <div class="row align-items-center py-1">
          <div class="pagination d-none"></div>
          <div class="col d-flex fs-9">
            <p class="mb-0 d-none d-sm-block me-3 fw-semibold text-body" data-list-info="data-list-info"></p>
            <a class="fw-semibold" href="#!" data-list-view="*">View all<span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span></a>
            <a class="fw-semibold d-none" href="#!" data-list-view="less">View Less</a>
          </div>
          <div class="col-auto d-flex">
            <button class="btn btn-link px-1 me-1" type="button" title="Previous" data-list-pagination="prev">
              <span class="fas fa-chevron-left me-2"></span>Previous
            </button>
            <button class="btn btn-link px-1 ms-1" type="button" title="Next" data-list-pagination="next">
              Next<span class="fas fa-chevron-right ms-2"></span>
            </button>
          </div>
        </div>
      </div>
    </div>

    <!-- Monthly and Yearly Charts Section -->
    <div class="mx-n4 px-4 mx-lg-n6 px-lg-6 bg-body-emphasis pt-6 pb-9 bsale-top">
      <div class="row g-4">
        <!-- Monthly Comparison -->
        <div class="col-12 col-xl-6">
          <div class="card h-100" style="overflow-x: auto;">
            <div class="card-header">
              <h5 class="mb-0">Monthly Sales Comparison</h5>
              <small class="text-body-tertiary">This Month vs Last Month</small>
            </div>
            <div class="card-body" style="overflow-x: auto;">
              <div class="echart-month-comparison" style="height:300px;"></div>
            </div>
          </div>
        </div>

        <!-- Yearly Comparison -->
        <div class="col-12 col-xl-6">
          <div class="card h-100">
            <div class="card-header">
              <h5 class="mb-0">Yearly Sales Comparison</h5>
              <small class="text-body-tertiary">This Year vs Last Year</small>
            </div>
            <div class="card-body">
              <div class="echart-year-comparison" style="height:300px;"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
</main>

<!-- Include JS scripts -->
<?php echo $__env->make('includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
// Pass PHP data to JavaScript
window.chartData = <?php echo json_encode($chartData ?? [], 15, 512) ?>;
window.salesStatus = <?php echo json_encode($salesStatus ?? [], 15, 512) ?>;
window.salesData = <?php echo json_encode($sales ?? [], 15, 512) ?>;

    // Sales actions script
    document.addEventListener("DOMContentLoaded", function() {
        // Verify sale action
        document.addEventListener('click', function(e) {
        const button = e.target.closest('.verify-sale'); // works even if inner icon is clicked
        if (!button) return; // ignore clicks outside verify-sale

        e.preventDefault();
        const saleId = button.getAttribute('data-sale-id'); // ✅ use button, not this

        if (confirm('Are you sure you want to verify this sale?')) {
            fetch(`/sales/${saleId}/verify`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({})
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    showToast('Sale verified successfully!', 'success');

                    // Update status badge
                    const statusBadge = button.closest('tr').querySelector('.status');
                    statusBadge.innerHTML = `
                        <span class="badge badge-phoenix fs-10 badge-phoenix-success">
                            <span class="badge-label">Verified</span>
                            <span class="ms-1" data-feather="check" style="height:12.8px;width:12.8px;"></span>
                        </span>
                    `;

                    // Hide the clicked button
                    button.style.display = 'none';

                    // Refresh Feather icons
                    if (typeof feather !== 'undefined') feather.replace();
                } else {
                    showToast('Error verifying sale: ' + data.message, 'danger');
                }
            })
            .catch(error => {
                showToast('Error verifying sale: ' + error.message, 'danger');
                console.error('Error:', error);
            });
        }
    });



    // Toast helper function
    function showToast(message, type = 'success') {
        // Remove existing toasts
        const existingToasts = document.querySelectorAll('.toast');
        existingToasts.forEach(toast => toast.remove());

        const toastHTML = `
            <div class="toast align-items-center text-bg-${type} bsale-0 show" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `;
        
        const toastContainer = document.querySelector('.toast-container');
        if (toastContainer) {
            toastContainer.innerHTML = toastHTML;
            const toastElement = toastContainer.querySelector('.toast');
            const toast = new bootstrap.Toast(toastElement, { delay: 4000 });
            toast.show();
        }
    }

    // Initialize Feather icons (if used)
    if (typeof feather !== 'undefined') {
        feather.replace();
    }
});
</script>
</body>
</html><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/dashboard/admin_list.blade.php ENDPATH**/ ?>