

<?php $__env->startSection('title', 'Product List'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">
        <span class="text-muted fw-light">Admin /</span> Products
    </h4>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Product List</h5>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addProductModal">
                <i class="fas fa-plus me-2"></i> Add Product
            </button>
        </div>

        <!-- Add Product Modal -->
        <div class="modal fade" id="addProductModal" tabindex="-1" aria-labelledby="addProductLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form id="addProductForm">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="addProductLabel">Add Product</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="productName" class="form-label">Product Name</label>
                                <input type="text" name="product_name" id="productName" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="productCategory" class="form-label">Category</label>
                                <select name="category_id" id="productCategory" class="form-control" required>
                                    <option value="">-- Select Category --</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="purchasePrice" class="form-label">Purchase Price</label>
                                <input type="number" step="0.01" name="purchase_price" id="purchasePrice" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="sellingPrice" class="form-label">Selling Price</label>
                                <input type="number" step="0.01" name="selling_price" id="sellingPrice" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="stock" class="form-label">Stock</label>
                                <input type="number" name="stock" id="stock" class="form-control" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Edit Product Modal -->
        <div class="modal fade" id="editProductModal" tabindex="-1" aria-labelledby="editProductLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form id="editProductForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="product_id" id="editProductId">
                        <div class="modal-header">
                            <h5 class="modal-title" id="editProductLabel">Edit Product</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="editProductName" class="form-label">Product Name</label>
                                <input type="text" name="product_name" id="editProductName" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="editProductCategory" class="form-label">Category</label>
                                <select name="category_id" id="editProductCategory" class="form-control" required>
                                    <option value="">-- Select Category --</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="editPurchasePrice" class="form-label">Purchase Price</label>
                                <input type="number" step="0.01" name="purchase_price" id="editPurchasePrice" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="editSellingPrice" class="form-label">Selling Price</label>
                                <input type="number" step="0.01" name="selling_price" id="editSellingPrice" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="editStock" class="form-label">Stock</label>
                                <input type="number" name="stock" id="editStock" class="form-control" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Delete Product Modal -->
        <div class="modal fade" id="deleteProductModal" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteProductModalLabel">Confirm Delete</h5>
                        <button class="btn btn-close p-1" type="button" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p class="text-body-tertiary lh-lg mb-0">
                            Are you sure you want to delete product <b id="deleteProductName"></b>?
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary" id="confirmDeleteProductBtn" type="button">Delete</button>
                        <button class="btn btn-outline-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Product Table -->
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" id="productTable">
                    <thead>
                        <tr>
                            <th class="text-center">#</th>
                            <th>Product</th>
                            <th>Category</th>
                            <th>Purchase Price</th>
                            <th>Selling Price</th>
                            <th>Stock</th>
                            <th>Updated At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Toast container -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index:2000"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const tableBody = $('#productTable tbody');

    function formatDate(dateString) {
        if (!dateString) return "—";
        const date = new Date(dateString);
        return isNaN(date) ? "—" : date.toLocaleString();
    }

    function showToast(message, type='success') {
        const toastHTML = `
            <div class="toast show text-${type}" role="alert" data-bs-autohide="true" data-bs-delay="5000">
                <div class="toast-header">
                    <strong class="me-auto">${type === 'success' ? 'Success' : 'Error'}</strong>
                    <small class="text-body-secondary">Just now</small>
                    <button class="btn ms-2 p-0" type="button" data-bs-dismiss="toast">
                        <span class="uil uil-times fs-7"></span>
                    </button>
                </div>
                <div class="toast-body">${message}</div>
            </div>`;
        const $toast = $(toastHTML);
        $('.toast-container').append($toast);
        new bootstrap.Toast($toast[0]).show();
    }

    function loadProducts() {
        $.ajax({
            url: "<?php echo e(url('/product/data')); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                tableBody.empty();
                data.forEach((product, index) => {
                    tableBody.append(`
                        <tr>
                            <td class="text-center">${index+1}</td>
                            <td>${product.product_name}</td>
                            <td>${product.category ? product.category.category_name : '—'}</td>
                            <td>${product.purchase_price}</td>
                            <td>${product.selling_price}</td>
                            <td>${product.stock}</td>
                            <td>${formatDate(product.updated_at)}</td>
                            <td>
                                <button class="btn btn-sm btn-warning edit-product-btn"
                                    data-id="${product.id}"
                                    data-name="${product.product_name}"
                                    data-category="${product.category_id}"
                                    data-purchase="${product.purchase_price}"
                                    data-price="${product.selling_price}"
                                    data-stock="${product.stock}">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger delete-product-btn"
                                    data-id="${product.id}"
                                    data-name="${product.product_name}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>`);
                });

                if ($.fn.DataTable.isDataTable('#productTable')) {
                    $('#productTable').DataTable().destroy();
                }
                $('#productTable').DataTable({ pageLength: 10, order:[[0,'asc']], responsive:true });
            },
            error: function(err) { showToast("Error fetching products", "danger"); }
        });
    }

    loadProducts();

    // Add Product
    $('#addProductForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: "<?php echo e(url('/product/store')); ?>",
            type: "POST",
            data: $(this).serialize(),
            success: function(res){
                location.reload();
                $('#addProductModal').modal('hide');
                $('#addProductForm')[0].reset();
                showToast(`Product <b>${res.product_name}</b> added successfully!`);
                
            },
            error: function(){ showToast("Error adding product", "danger"); }
        });
    });

    // Open Edit Modal
    $(document).on('click', '.edit-product-btn', function(){
        $('#editProductId').val($(this).data('id'));
        $('#editProductName').val($(this).data('name'));
        $('#editProductCategory').val($(this).data('category'));
        $('#editPurchasePrice').val($(this).data('purchase'));
        $('#editSellingPrice').val($(this).data('price'));
        $('#editStock').val($(this).data('stock'));
        $('#editProductModal').modal('show');
    });

    // Edit Product
    $('#editProductForm').on('submit', function(e){
        e.preventDefault();
        const id = $('#editProductId').val();
        $.ajax({
            url: "<?php echo e(url('/product/update')); ?>/" + id,
            type: "PUT",
            data: $(this).serialize(),
            success: function(res){
                location.reload();
                $('#editProductModal').modal('hide');
                showToast(`Product <b>${res.product_name}</b> updated successfully!`);
                
            },
            error: function(){ showToast("Error updating product", "danger"); }
        });
    });

    // Delete Product
    let deleteProductId = null;
    $(document).on('click', '.delete-product-btn', function(){
        deleteProductId = $(this).data('id');
        $('#deleteProductName').text($(this).data('name'));
        $('#deleteProductModal').modal('show');
    });

    $('#confirmDeleteProductBtn').on('click', function(){
        if(!deleteProductId) return;
        $.ajax({
            url: "<?php echo e(url('/product/delete')); ?>/"+deleteProductId,
            type: "DELETE",
            data: {_token:"<?php echo e(csrf_token()); ?>"},
            success: function(res){
                $('#deleteProductModal').modal('hide');
                showToast(`Product deleted successfully!`);
                location.reload();
            },
            error: function(){ showToast("Error deleting product", "danger"); }
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/product/list.blade.php ENDPATH**/ ?>