<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo e($title); ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; }
        .header h2 { margin: 0; color: #333; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; font-weight: bold; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .footer { margin-top: 20px; text-align: center; font-size: 10px; color: #666; }
        .totals { font-weight: bold; background-color: #f8f9fa; }
    </style>
</head>
<body>
    <div class="header">
        <h2><?php echo e($title); ?></h2>
        <p>Generated on: <?php echo e(date('F d, Y H:i:s')); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Product Name</th>
                <th>Date</th>
                <th>Opening</th>
                <th>Additional</th>
                <th>Buying Price</th>
                <th>Selling Price</th>
                <th>Sold</th>
                <th>Amount</th>
                <th>Profit</th>
                <th>Closed</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $totalSold = 0;
                $totalAmount = 0;
                $totalProfit = 0;
                $totalClosed = 0;
            ?>
            <?php $__currentLoopData = $stocktakingData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="text-center"><?php echo e($index + 1); ?></td>
                <td><?php echo e($item['product_name']); ?></td>
                <td class="text-center"><?php echo e($item['date']); ?></td>
                <td class="text-center"><?php echo e($item['opening_stock']); ?></td>
                <td class="text-center"><?php echo e($item['additional_stock']); ?></td>
                <td class="text-right">Tsh <?php echo e($item['buying_price']); ?></td>
                <td class="text-right">Tsh <?php echo e($item['selling_price']); ?></td>
                <td class="text-center"><?php echo e($item['sold_quantity']); ?></td>
                <td class="text-right">Tsh <?php echo e($item['amount_obtained']); ?></td>
                <td class="text-right">Tsh <?php echo e($item['profit']); ?></td>
                <td class="text-center"><?php echo e($item['closed_stock']); ?></td>
            </tr>
            <?php
                $totalSold += $item['sold_quantity'];
                $totalAmount += floatval(str_replace(',', '', $item['amount_obtained']));
                $totalProfit += floatval(str_replace(',', '', $item['profit']));
                $totalClosed += $item['closed_stock'];
            ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot class="totals">
            <tr>
                <td colspan="7" class="text-right"><strong>TOTALS:</strong></td>
                <td class="text-center"><strong><?php echo e($totalSold); ?></strong></td>
                <td class="text-right"><strong>Tsh <?php echo e(number_format($totalAmount, 2)); ?></strong></td>
                <td class="text-right"><strong>Tsh <?php echo e(number_format($totalProfit, 2)); ?></strong></td>
                <td class="text-center"><strong><?php echo e($totalClosed); ?></strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>D-Restaurant Stocktaking System</p>
    </div>
</body>
</html><?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/stocktaking/export-pdf.blade.php ENDPATH**/ ?>