<nav class="navbar navbar-top fixed-top navbar-expand" id="navbarDefault" >
    <div class="collapse navbar-collapse justify-content-between">
        <div class="navbar-logo">
<button class="btn navbar-toggler navbar-toggler-humburger-icon hover-bg-transparent"
        type="button"
        data-bs-toggle="collapse"
        data-bs-target="#navbarVerticalCollapse"
        aria-controls="navbarVerticalCollapse"
        aria-expanded="false"
        aria-label="Toggle Navigation">
    <span class="navbar-toggle-icon">
        <span class="toggle-line"></span>
    </span>
</button>

        <?php
            $roleName = match(Auth::user()->is_role) {
                1 => 'Admin',
                2 => 'Cashier',
                3 => 'Waiter',
                default => 'User',
            };
        ?>
        

            <a class="navbar-brand me-1 me-sm-3" href="<?php echo e(url('dashboard')); ?>">
                <div class="d-flex align-items-center">
                    <div class="d-flex align-items-center">
                       <!-- <img src="<?php echo e(asset('assets/img/icons/logo.png')); ?>" alt="phoenix" width="27" /> -->
                        <h5 class="logo-text ms-2 d-none d-sm-block">D-Restaurant POS</h5>
                    </div>
                </div>
            </a>
        </div>
        

        <!-- Navbar Icons -->
        <ul class="navbar-nav navbar-nav-icons flex-row">
            <!-- Theme Toggle -->
            <li class="nav-item">
                <div class="theme-control-toggle fa-icon-wait px-2">
                    <input class="form-check-input ms-0 theme-control-toggle-input" 
                           type="checkbox" 
                           data-theme-control="phoenixTheme" 
                           value="dark" 
                           id="themeControlToggle" />
                    <label class="mb-0 theme-control-toggle-label theme-control-toggle-light" 
                           for="themeControlToggle" 
                           style="height:32px;width:32px;">
                        <span class="icon" data-feather="moon"></span>
                    </label>
                    <label class="mb-0 theme-control-toggle-label theme-control-toggle-dark" 
                           for="themeControlToggle" 
                           style="height:32px;width:32px;">
                        <span class="icon" data-feather="sun"></span>
                    </label>
                </div>
            </li>

            
            <!-- Calculator Menu -->
<li class="nav-item dropdown">
    <a class="nav-link" id="navbarDropdownCalculator" href="#" role="button"
       data-bs-toggle="dropdown" aria-haspopup="true" data-bs-auto-close="outside"
       aria-expanded="false">
        <!-- Calculator Icon (9 dots kept for consistency, can swap if you like) -->
        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
             xmlns="http://www.w3.org/2000/svg">
            <circle cx="2" cy="2" r="2" fill="currentColor"></circle>
            <circle cx="8" cy="2" r="2" fill="currentColor"></circle>
            <circle cx="14" cy="2" r="2" fill="currentColor"></circle>
            <circle cx="2" cy="8" r="2" fill="currentColor"></circle>
            <circle cx="8" cy="8" r="2" fill="currentColor"></circle>
            <circle cx="14" cy="8" r="2" fill="currentColor"></circle>
            <circle cx="2" cy="14" r="2" fill="currentColor"></circle>
            <circle cx="8" cy="14" r="2" fill="currentColor"></circle>
            <circle cx="14" cy="14" r="2" fill="currentColor"></circle>
        </svg>
    </a>

    <div class="dropdown-menu dropdown-menu-end navbar-dropdown-caret py-0 dropdown-nine-dots shadow border"
         aria-labelledby="navbarDropdownCalculator">
        <div class="card bg-body-emphasis position-relative border-0">
            <div class="card-body p-3" style="width: 280px;">
                <!-- Calculator Display -->
                <div class="mb-3">
                    <input type="text" id="calc-display" class="form-control text-end fs-5 fw-bold"
                           placeholder="0" readonly />
                </div>
                <!-- Calculator Buttons -->
                <div class="row g-2 text-center">
                    <div class="col-3"><button class="btn btn-light w-100" onclick="clearCalc()">C</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('/')">÷</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('*')">×</button></div>
                    <div class="col-3"><button class="btn btn-danger w-100" onclick="deleteLast()">⌫</button></div>

                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('7')">7</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('8')">8</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('9')">9</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('-')">−</button></div>

                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('4')">4</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('5')">5</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('6')">6</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('+')">+</button></div>

                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('1')">1</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('2')">2</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('3')">3</button></div>
                    <div class="col-3" rowspan="2">
                        <button class="btn btn-success w-100 h-100" onclick="calculateResult()">=</button>
                    </div>

                    <div class="col-6"><button class="btn btn-light w-100" onclick="appendValue('0')">0</button></div>
                    <div class="col-3"><button class="btn btn-light w-100" onclick="appendValue('.')">.</button></div>
                </div>
            </div>
        </div>
    </div>
</li>

<!-- Calculator JS -->
<script>
    const display = document.getElementById("calc-display");

    function appendValue(val) {
        display.value = display.value === "0" ? val : display.value + val;
    }

    function clearCalc() {
        display.value = "0";
    }

    function deleteLast() {
        display.value = display.value.slice(0, -1) || "0";
    }

    function calculateResult() {
        try {
            display.value = eval(display.value.replace(/÷/g, "/").replace(/×/g, "*"));
        } catch {
            display.value = "Error";
        }
    }

    // Allow keyboard input
    document.addEventListener("keydown", function (e) {
        if (!document.querySelector('#navbarDropdownCalculator[aria-expanded="true"]')) return;

        if (!isNaN(e.key) || "+-*/.".includes(e.key)) {
            appendValue(e.key);
        } else if (e.key === "Enter") {
            calculateResult();
        } else if (e.key === "Backspace") {
            deleteLast();
        } else if (e.key.toLowerCase() === "c") {
            clearCalc();
        }
    });
</script>


<!-- User name & profile combined -->
<li class="nav-item dropdown d-flex align-items-center" style="min-width:0; max-width:200px;">
    
<!-- Username clickable same as avatar -->
<a class="d-flex align-items-center text-decoration-none nav-link lh-1 pe-0" 
   id="navbarDropdownUser" href="#!" role="button"
   data-bs-toggle="dropdown" data-bs-auto-close="outside"
   aria-haspopup="true" aria-expanded="false"
   style="cursor:pointer;">

    <span class="d-block flex-shrink-1 text-truncate me-2" 
          style="height:30px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;">
        <h5 class="text-muted fw-light mt-2 mb-0"><?php echo e(ucwords(Auth::user()->username)); ?></h5>
    </span>

    <div class="avatar avatar-l rounded-circle d-flex align-items-center justify-content-center bg-primary text-white" 
         style="width:40px; height:40px; font-weight:bold; font-size:14px;">
        <?php
            $name = Auth::user()->username;
            $initials = collect(explode(' ', $name))->map(function($word){ return strtoupper(substr($word,0,1)); })->implode('');
        ?>
        <?php echo e($initials); ?>

    </div>
</a>




    <!-- Dropdown -->
    <div class="dropdown-menu dropdown-menu-end navbar-dropdown-caret py-0 dropdown-profile shadow border" 
         aria-labelledby="navbarDropdownUser">
        <div class="card position-relative border-0">
            <div class="card-body p-0">
            <div class="text-center pt-4 pb-3">
                <div class="avatar avatar-xl rounded-circle d-flex align-items-center justify-content-center 
                            bg-primary text-white mx-auto" 
                    style="width:72px; height:72px; font-weight:bold; font-size:24px;">
                    <?php
                        $name = Auth::user()->username;
                        $initials = collect(explode(' ', $name))
                                    ->map(fn($word) => strtoupper(substr($word,0,1)))
                                    ->implode('');
                    ?>
                    <?php echo e($initials); ?>

                </div>
                <h6 class="mt-2 text-body-emphasis"><?php echo e(ucwords(Auth::user()->username)); ?></h6>
            </div>
        </div>

            <div class="overflow-auto scrollbar" style="max-height: 15rem;">
                <ul class="nav d-flex flex-column mb-2 pb-1">
                <li class="nav-item">
                    <a class="nav-link px-3 d-block" href="#!" data-bs-toggle="modal" data-bs-target="#userProfileModal">
                        <span class="me-2 text-body align-bottom" data-feather="user"></span>
                        <span>Profile</span>
                    </a>
                </li>

                    <li class="nav-item">
                        <a class="nav-link px-3 d-block" href="dashboard">
                            <span class="me-2 text-body align-bottom" data-feather="pie-chart"></span>
                            <span>Dashboard</span>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="card-footer p-0 border-top border-translucent">
                <hr />
                <div class="px-3">
                    <a class="btn btn-phoenix-secondary bg-danger d-flex flex-center w-100 text-white" href="<?php echo e(url('logout')); ?>">
                        <span class="me-2" data-feather="log-out"></span>
                        <span >Sign out</span>
                    </a>
                </div>
                <div class="my-2 text-center fw-bold fs-10 text-body-quaternary">
                   
                </div>
            </div>
        </div>
    </div>
</li>

        </ul>
    </div>
</nav>
<!-- User Profile Modal -->
<div class="modal fade" id="userProfileModal" tabindex="-1" aria-labelledby="userProfileModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="userProfileForm">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="userProfileModalLabel">User Profile</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Name (readonly) -->
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" id="profileName" class="form-control" 
                               value="<?php echo e(Auth::user()->username); ?>" readonly>
                    </div>

                    <!-- Email (readonly for non-admin, editable for admin) -->
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" id="profileEmail" class="form-control" 
                               value="<?php echo e(Auth::user()->email); ?>" 
                               <?php if(Auth::user()->is_role != 1): ?> readonly <?php endif; ?>>
                    </div>

                    <!-- Role (readonly) -->
                    <div class="mb-3">
                        <label class="form-label">Role</label>
                        <input type="text" id="profileRole" class="form-control" 
                               value="<?php echo e(Auth::user()->is_role == 1 ? 'Admin' : (Auth::user()->is_role == 2 ? 'Cashier' : 'Waiter')); ?>" 
                               readonly>
                    </div>

                    <!-- Password (editable for admin) -->
                    <?php if(Auth::user()->is_role == 1): ?>
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" id="profilePassword" name="password" class="form-control" placeholder="Leave blank to keep current">
                    </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <?php if(Auth::user()->is_role == 1): ?>
                        <button type="button" class="btn btn-primary" id="editProfileBtn">Edit</button>
                        <button type="submit" class="btn btn-success d-none" id="saveProfileBtn">Save</button>
                    <?php endif; ?>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const user = <?php echo json_encode(Auth::user(), 15, 512) ?>;

    const nameInput = document.getElementById('profileName');
    const emailInput = document.getElementById('profileEmail');
    const roleInput = document.getElementById('profileRole');

    // Show user info in modal
    $('#userProfileModal').on('show.bs.modal', function () {
        nameInput.value = user.name;
        emailInput.value = user.email;
        roleInput.value = user.is_role == 1 ? 'Admin' : (user.is_role == 2 ? 'Cashier' : 'Waiter');

        <?php if(Auth::user()->is_role == 1): ?>
        // Admin: allow editing
        $('#editProfileBtn').on('click', function() {
            nameInput.removeAttribute('readonly');
            emailInput.removeAttribute('readonly');
            $('#editProfileBtn').addClass('d-none');
            $('#saveProfileBtn').removeClass('d-none');
        });

        $('#userProfileForm').on('submit', function(e) {
            e.preventDefault();

            $.ajax({
                url: "<?php echo e(url('admin/users/update')); ?>/" + user.id,
                type: "PUT",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    name: nameInput.value,
                    email: emailInput.value,
                    is_role: user.is_role
                },
                success: function(response) {
                    $('#userProfileModal').modal('hide');
                    location.reload();
                    alert('Profile updated successfully!');
                },
                error: function(xhr) {
                    alert('Error updating profile. Try again.');
                }
            });
        });
        <?php endif; ?>
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/stephen/domains/pos.acadogar.com/laravel/restaurant/resources/views/partials/navbar.blade.php ENDPATH**/ ?>