(function (factory) {
  typeof define === 'function' && define.amd ? define(factory) :
  factory();
})((function () { 'use strict';

  const avatarTemplate=a=>`\n<a class="dropdown-toggle dropdown-caret-none d-inline-block" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-auto-close="outside">\n  <div class="avatar avatar-m rounded-circle border border-light-subtle">\n    <img class="rounded-circle ${"team/avatar.webp"===a.avatar?"avatar-placeholder":""}" src="../../assets/img/${a.avatar}" alt="" />\n  </div>\n</a>\n<div class="dropdown-menu avatar-dropdown-menu p-0 overflow-hidden" style="width: 320px;">\n  <div class="position-relative">\n    <div class="bg-holder z-n1" style="background-image:url(../../assets/img/bg/bg-32.png);background-size: auto;">\n    </div>\n    <div class="p-3">\n      <div class="text-end">\n        <button class="btn p-0 me-2"><span class="fa-solid fa-user-plus text-white"></span></button>\n        <button class="btn p-0"><span class="fa-solid fa-ellipsis text-white"></span></button>\n      </div>\n      <div class="text-center">\n        <div class="avatar avatar-xl status-online position-relative me-2 me-sm-0 me-xl-2 mb-2"><img class="rounded-circle border border-light-subtle" src="../../assets/img/${a.avatar}" alt="" /></div>\n        <h6 class="text-white">${a.name}</h6>\n        <p class="text-light text-opacity-50 fw-semibold fs-10 mb-2">@tyrion222</p>\n        <div class="d-flex flex-center mb-3">\n          <h6 class="text-white mb-0">224 <span class="fw-normal text-light text-opacity-75">connections</span></h6><span class="fa-solid fa-circle text-body-tertiary mx-1" data-fa-transform="shrink-10 up-2"></span>\n          <h6 class="text-white mb-0">23 <span class="fw-normal text-light text-opacity-75">mutual</span></h6>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div class="bg-body-emphasis">\n    <div class="p-3 border-bottom border-translucent">\n      <div class="d-flex justify-content-between">\n        <div class="d-flex">\n          <button class="btn btn-phoenix-secondary btn-icon btn-icon-lg me-2"><span class="fa-solid fa-phone"></span></button>\n          <button class="btn btn-phoenix-secondary btn-icon btn-icon-lg me-2"><span class="fa-solid fa-message"></span></button>\n          <button class="btn btn-phoenix-secondary btn-icon btn-icon-lg"><span class="fa-solid fa-video"></span></button>\n        </div>\n        <button class="btn btn-phoenix-primary"><span class="fa-solid fa-envelope me-2"></span>Send Email</button>\n      </div>\n    </div>\n    <ul class="nav d-flex flex-column py-3 border-bottom">\n      <li class="nav-item"><a class="nav-link px-3 d-flex flex-between-center" href="#!"> <span class="me-2 text-body d-inline-block" data-feather="clipboard"></span><span class="text-body-highlight flex-1">Assigned Projects</span><span class="fa-solid fa-chevron-right fs-11"></span></a></li>\n      <li class="nav-item"><a class="nav-link px-3 d-flex flex-between-center" href="#!"> <span class="me-2 text-body" data-feather="pie-chart"></span><span class="text-body-highlight flex-1">View activiy</span><span class="fa-solid fa-chevron-right fs-11"></span></a></li>\n    </ul>\n  </div>\n  <div class="p-3 d-flex justify-content-between"><a class="btn btn-link p-0 text-decoration-none" href="#!">Details </a><a class="btn btn-link p-0 text-decoration-none text-danger" href="#!">Unassign </a></div>\n</div>\n`,timelineTemplate=(a,s,n)=>`\n<div class="timeline-item">\n  <div class="row g-3">\n    <div class="col-auto">\n      <div class="timeline-item-bar position-relative">\n        <div class="icon-item icon-item-md rounded-7 border border-translucent">\n          <span class="${a.icon} text-${a.iconColor} fs-9"></span>\n        </div>\n          ${s!==n.activities.length-1?'<span class="timeline-bar border-end border-dashed"></span>':""}\n      </div>\n    </div>\n    <div class="col mb-5">\n      <div class="d-flex justify-content-between">\n        <div class="d-flex mb-2">\n          <h6 class="lh-sm mb-0 me-2 text-body-secondary timeline-item-title">${a.title}</h6>\n        </div>\n        <p class="text-body-quaternary fs-9 mb-0 text-nowrap timeline-time"><span class="fa-regular fa-clock me-1"></span>${a.time}</p>\n      </div>\n      <h6 class="fs-10 fw-normal mb-3">by <a class="fw-semibold" href="#!">${a.tasker}</a></h6>\n      <div class="avatar-group avatar-group-dense">\n        ${a.assignees?a.assignees.map((a=>avatarTemplate(a))).join(""):""}\n        ${a.more?'\n          <div class="avatar avatar-m  rounded-circle">\n            <div class="avatar-name rounded-circle "><span>+1</span></div>\n          </div>':""}\n      </div>\n    </div>\n  </div>\n</div>\n`,detailsTemplate=a=>`\n<tr>\n  <td class="py-1 align-middle">\n    <h5 class="mb-0">${a.key}</h5>\n  </td>\n  <td class="py-1 align-middle">:</td>\n  <td class="py-1 align-middle">\n    ${a.value}\n    ${a.modifiedBy?'by <a class="fs-9 fw-bolder" href="#!">John Doe</a></td>':""}\n  </td>\n</tr>\n`;const getFileDetailsTemplate=a=>`\n  <div>\n    <h3>${a.name}</h3>\n    <ul class="nav nav-underline file-details-tab fs-9 flex-nowrap gap-0 mt-4 mb-5" id="fileDetailsTab" role="tablist">\n      <li class="nav-item text-nowrap w-50 text-center" role="presentation"><a class="nav-link active" id="details-tab" data-bs-toggle="tab" href="#tab-details" role="tab" aria-controls="tab-details" aria-selected="false" tabindex="-1">File Details</a></li>\n      <li class="nav-item text-nowrap w-50 text-center me-2" role="presentation"><a class="nav-link" id="activity-tab" data-bs-toggle="tab" href="#tab-activity" role="tab" aria-controls="tab-activity" aria-selected="false" tabindex="-1">File Activity</a></li>\n    </ul>\n    <div class="tab-content" id="fileDetailsTab">\n      <div class="tab-pane fade active show" id="tab-details" role="tabpanel" aria-labelledby="details-tab">\n        ${"folder"===a.type?`<span class="fa-solid fa-folder fs-1 mb-3 ${3===a.id?"text-info-light":""}"></span>`:""}\n        ${"doc"===a.type?'<span class="fa-solid fa-file-word fs-1 mb-3"></span>':""}\n        ${"xls"===a.type?'<span class="fa-solid fa-file-excel fs-1 mb-3"></span>':""}\n        ${"source-code"===a.type?'<span class="fa-solid fa-file-invoice fs-1 mb-3"></span>':""}\n        ${"zip"===a.type?'<span class="fa-solid fa-file-zipper fs-1 mb-3"></span>':""}\n        ${"html"===a.type?'<span class="fa-solid fa-file-code fs-1 mb-3"></span>':""}\n        ${"pdf"===a.type?'<span class="fa-solid fa-file-pdf fs-1 mb-3"></span>':""}\n        ${"image"===a.type?`<img class="w-100 h-100 object-fit-cover rounded-2 mb-3" src="../../assets/${a.img}" alt="" style='aspect-ratio: 16/9' />`:""}\n        ${"video"===a.type?`\n            <video class="d-block h-100 w-100 overflow-hidden rounded-2 object-fit-cover mb-3" muted="muted" controls poster="../../assets/${a.video.split(".")[0]}.png" style='aspect-ratio: 16/9'>\n              <source src="../../assets/${a.video}" type="video/mp4" />\n            </video>\n            `:""}\n        <table class="table table-borderless">\n          <tr>\n            <th class="p-0" style="width: 110px"></th>\n            <th class="p-0 text-center" style="width: 20px"></th>\n            <th class="p-0"></th>\n          </tr>\n          ${a.details.map((a=>detailsTemplate(a))).join("")}\n        </table>\n        <hr class="mb-4" />\n        <h5 class="mb-3">Admin</h5>\n        <div class="avatar avatar-m ">\n          ${avatarTemplate(a.admin)}\n        </div>\n        <h5 class="mb-3 mt-5">Team members</h5>\n        <div class="avatar-group avatar-group-dense">\n        ${a.assignees.map((a=>avatarTemplate(a))).join("")}\n        </div>\n        <a class="btn btn-link p-0" href="#!">Control Access<span class="fa-solid fa-chevron-right ms-2 mt-2"></span></a>\n        <hr class="my-4" />\n        <h5 class="mb-3 mb-3">File Link</h5>\n        <h6 class="fw-normal text-body">${a.fileLink}</h6>\n        <button class="btn btn-phoenix-primary mt-2"><span class="fa-solid fa-link me-2"></span>Copy link</button>\n      </div>\n      <div class="tab-pane fade" id="tab-activity" role="tabpanel" aria-labelledby="activity-tab">\n        <h4 class="mb-3">Today</h4>\n        <div class="timeline-basic">\n          ${a.activities.map(((s,n)=>timelineTemplate(s,n,a))).join("")}\n        </div>\n      </div>\n    </div>\n  </div>\n`;const skeletonTemplate='\n<div aria-hidden="true">\n  <h5 class="placeholder-glow mb-2">\n    <span class="placeholder col-8 bg-body-secondary py-3"></span>\n  </h5>\n  <div class=\'placeholder-glow mb-2 d-flex gap-2\'>\n    <span class="placeholder col-6 py-3 bg-body-secondary"></span>\n    <span class="placeholder col-6 py-3 bg-body-secondary"></span>\n  </div>\n  <span class="placeholder col-12 bg-body-secondary mb-3" style=\'height: 150px\'></span>\n  <p class="card-text placeholder-glow">\n    <span class="placeholder col-12 py-2 mb-2 bg-body-secondary"></span>\n    <span class="placeholder col-8 py-2 mb-2 bg-body-secondary"></span>\n    <span class="placeholder col-12 py-2 mb-2 bg-body-secondary"></span>\n    <span class="placeholder col-10 py-2 mb-2 bg-body-secondary"></span>\n  </p>\n</div>\n';

  const myFiles=[{id:1,name:"Illustrations",type:"folder",itemCount:"20 Items",modified:"2 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Kristine Cadena",avatar:"team/2.webp"},assignees:[{name:"Kristine Cadena",avatar:"team/2.webp"},{name:"Adrian",avatar:"team/4.webp"},{name:"Charles",avatar:"team/3.webp"},{name:"Jennifer Schramm",avatar:"team/avatar.webp"},{name:"Roy Anderson",avatar:"team/r.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:2,name:"Retro Ring.jpg",type:"image",size:"980 KB",img:"img/file-manager/9.png",modified:"10 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Raymond Mims",avatar:"team/10.webp"},assignees:[{name:"Raymond Mims",avatar:"team/10.webp"},{name:"Jonathan",avatar:"team/11.webp"},{name:"Jack",avatar:"team/12.webp"},{name:"Jessica",avatar:"team/13.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:3,name:"Brand Identity",type:"folder",itemCount:"16 Items",modified:"2 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carl",avatar:"team/7.webp"},assignees:[{name:"Carl",avatar:"team/7.webp"},{name:"Robert Allan",avatar:"team/21.webp"},{name:"Charles",avatar:"team/3.webp"},{name:"Adrian",avatar:"team/4.webp"},{name:"Sarah Gill",avatar:"team/28.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:4,name:"World in Motion.mp4",type:"video",video:"video/2.mp4",size:"18 MB",modified:"15 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"William Grant",avatar:"team/1.webp"},assignees:[{name:"William Grant",avatar:"team/1.webp"},{name:"Kristine Cadena",avatar:"team/2.webp"},{name:"Charles",avatar:"team/3.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:5,name:"UI Design",type:"folder",itemCount:"10 Items",modified:"20 September, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Luke Davies",avatar:"team/5.webp"},assignees:[{name:"Luke Davies",avatar:"team/5.webp"},{name:"Sophie Grant",avatar:"team/6.webp"},{name:"Jack",avatar:"team/12.webp"},{name:"William Ellison",avatar:"team/23.webp"},{name:"Jennifer Schramm",avatar:"team/avatar.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:6,name:"Classic Clicks.png",type:"image",size:"564 KB",img:"img/file-manager/11.png",modified:"2 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"William Grant",avatar:"team/1.webp"},assignees:[{name:"William Grant",avatar:"team/1.webp"},{name:"Kristine Cadena",avatar:"team/2.webp"},{name:"Charles",avatar:"team/3.webp"},{name:"Jennifer Schramm",avatar:"team/avatar.webp"}],more:"+2",fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:7,name:"Source Code",type:"folder",itemCount:"21 Items",modified:"21 September, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Robert Allan",avatar:"team/21.webp"},assignees:[{name:"Robert Allan",avatar:"team/21.webp"},{name:"Molly William",avatar:"team/27.webp"},{name:"Sarah Gill",avatar:"team/28.webp"},{name:"Jennifer Schramm",avatar:"team/avatar.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:8,name:"Code Backup",type:"folder",itemCount:"19 Items",modified:"21 September, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Rose Berry",avatar:"team/18.webp"},assignees:[{name:"Rose Berry",avatar:"team/18.webp"},{name:"Tim Anderson",avatar:"team/22.webp"},{name:"William Ellison",avatar:"team/23.webp"},{name:"Jean Renoir",avatar:"team/34.webp"},{name:"Stanly Drinkwater",avatar:"team/35.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:9,name:"Trip List.xls",type:"xls",size:"553 KB",modified:"2 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Warren",avatar:"team/24.webp"},assignees:[{name:"Warren",avatar:"team/24.webp"},{name:"William Ellison",avatar:"team/23.webp"},{name:"Charles",avatar:"team/3.webp"},{name:"Jennifer Schramm",avatar:"team/avatar.webp"}],more:"+3",fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:10,name:"Archive.zip",type:"zip",size:"12 MB",modified:"10 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Nicola Allan",avatar:"team/16.webp"},assignees:[{name:"Nicola Allan",avatar:"team/16.webp"},{name:"Ansolo Lazinatov",avatar:"team/19.webp"},{name:"Charles",avatar:"team/3.webp"},{name:"Jennifer Schramm",avatar:"team/avatar.webp"}],more:"+8",fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:11,name:"Worldly Wonders.jpg",type:"image",size:"990 KB",img:"img/file-manager/12.png",modified:"10 September, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/1.webp"},assignees:[{name:"William Grant",avatar:"team/1.webp"},{name:"Kristine Cadena",avatar:"team/2.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:12,name:"Phoenix Logs.csv",type:"csv",size:"546 KB",modified:"2 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"William Grant",avatar:"team/1.webp"},assignees:[{name:"William Grant",avatar:"team/1.webp"},{name:"Kristine Cadena",avatar:"team/2.webp"},{name:"Charles",avatar:"team/3.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:13,name:"Notes.xlx",type:"xlx",size:"698 KB",modified:"2 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Kristine Cadena",avatar:"team/70.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:14,name:"Moving Escapes.mp4",type:"video",size:"12 MB",video:"video/3.mp4",modified:"4 hours ago",details:[{key:"File type",value:"Folder"},{key:"File size",value:"800 MB"},{key:"Storage used",value:"800 MB"},{key:"Files",value:"20 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"30 Jun, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Kristine Cadena",avatar:"team/70.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-share-nodes",iconColor:"success",title:"You have shared this file.",tasker:"John N. Ward",assignees:[{name:"Michael Jenkins",avatar:"team/9.webp"},{name:"Ansolo Lazinatov",avatar:"team/25.webp"},{name:"Jennifer Schramm",avatar:"team/32.webp"},{name:"Kristine Cadena",avatar:"team/avatar.webp"}],more:"+1"},{time:"12:30pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:33am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:15,name:"API Documentation.pdf",type:"pdf",size:"4 MB",modified:"10 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/71.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/10.webp"},{name:"Ansolo Lazinatov",avatar:"team/26.webp"},{name:"Jennifer Schramm",avatar:"team/21.webp"},{name:"Kristine Cadena",avatar:"team/12.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:16,name:"Vintage Car.jpg",type:"image",size:"980 KB",img:"img/file-manager/13.png",modified:"15 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/71.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/10.webp"},{name:"Ansolo Lazinatov",avatar:"team/26.webp"},{name:"Jennifer Schramm",avatar:"team/21.webp"},{name:"Kristine Cadena",avatar:"team/12.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:17,name:"Sleek Rides.png",type:"image",size:"980 KB",img:"img/file-manager/15.png",modified:"16 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/71.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/10.webp"},{name:"Ansolo Lazinatov",avatar:"team/26.webp"},{name:"Jennifer Schramm",avatar:"team/21.webp"},{name:"Kristine Cadena",avatar:"team/12.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"}]},{id:18,name:"Notes.txt",type:"zip",size:"29 MB",modified:"17 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/71.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/10.webp"},{name:"Ansolo Lazinatov",avatar:"team/26.webp"},{name:"Jennifer Schramm",avatar:"team/21.webp"},{name:"Kristine Cadena",avatar:"team/12.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]},{id:19,name:"Mountain Majesty.jpg",type:"image",size:"2 MB",img:"img/file-manager/16.png",modified:"17 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/71.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/10.webp"},{name:"Ansolo Lazinatov",avatar:"team/26.webp"},{name:"Jennifer Schramm",avatar:"team/21.webp"},{name:"Kristine Cadena",avatar:"team/12.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"}]},{id:20,name:"Job Confirmation.doc",type:"doc",size:"129 KB",modified:"17 July, 2023",details:[{key:"File type",value:"Folder"},{key:"File size",value:"520 MB"},{key:"Storage used",value:"520 MB"},{key:"Files",value:"16 items"},{key:"File location",value:"App Documentation"},{key:"Last opened",value:"05 Jul, 2023"},{key:"Last modified",value:"10 July, 2023",modifiedBy:"John Doe"},{key:"Created date",value:"12 Feb, 2023"}],admin:{name:"Carry Anna",avatar:"team/71.webp"},assignees:[{name:"Michael Jenkins",avatar:"team/10.webp"},{name:"Ansolo Lazinatov",avatar:"team/26.webp"},{name:"Jennifer Schramm",avatar:"team/21.webp"},{name:"Kristine Cadena",avatar:"team/12.webp"}],fileLink:"http://sample.info/?insect=fireman&porter=attraction# cave",activities:[{time:"4:33pm",icon:"fa-solid fa-swatchbook",iconColor:"success",title:"Designing the dungeon",tasker:"Igor Borvibson",assignees:[{name:"Roy Anderson",avatar:"team/11.webp"},{name:"Ansolo Lazinatov",avatar:"team/35.webp"},{name:"Jennifer Schramm",avatar:"team/23.webp"},{name:"Kristine Cadena",avatar:"team/57.webp"}],more:"+2"},{time:"03:00pm",icon:"fa-solid fa-edit",iconColor:"danger",title:"You have edited this file.",tasker:"John N. Ward"},{time:"9:00am",icon:"fa-solid fa-cloud-arrow-up",iconColor:"info",title:"You have uploaded this file.",tasker:"John N. Ward"}]}];

  const fileManagerInit=()=>{const e=document.querySelector("[data-files-container]"),t=document.querySelector("[data-details-container]"),s=t.querySelector("[data-file-details]"),i=document.querySelector("[data-files-selected]"),l=document.querySelector("[data-collapse-filemanager-sidebar]"),n=document.querySelector("[data-toggle-sidebar]"),a=document.querySelectorAll("[data-toggle-file-details]"),d=document.querySelectorAll("[data-file-thumbnail]"),o=document.querySelector("[data-remove-bulk-check]"),c=document.querySelector("#file-manager-replace-element"),r=document.querySelector("#file-manager-actions"),m=document.querySelector("[data-bulk-select]"),u=window.phoenix.BulkSelect.getInstance(m);let g=0,p=[],b=null;const f=()=>{if(g>0&&(i.textContent=`${g} ${1===g?"item":"items"} selected`),1===g){const e=getFileDetailsTemplate(p[0]);s.innerHTML=e;}else s.innerHTML=`\n        <div class='text-center px-4'>\n          ${g>0?`<h5 class='mb-3'>${g} items selected</h5>`:""}\n          <img class='d-dark-none img-fluid' src='../../assets/img/spot-illustrations/46.png'>\n          <img class='d-light-none img-fluid' src='../../assets/img/spot-illustrations/dark_46.png'>\n          ${0===g?"<h5 class='mt-4'>Select an item to view more information</h5>":""}\n        </div>\n      `;},h=[];d.forEach(((e,t)=>{const s={},i=e.getAttribute("data-file-thumbnail");s.href=`../../assets/${i}`,s.type="mp4"===i.split(".")[1]?"video":"image",h.push(s),e.setAttribute("data-file-index",t);})),e.addEventListener("click",(e=>{if(null!==b&&(clearTimeout(b),b=null),"INPUT"===e.target.tagName){const t=e.target;if(t.hasAttribute("data-bulk-select"))g=u.getSelectedRows().length,p=[...myFiles.slice(0,g)];else {const e=myFiles.find((e=>e.id===parseInt(t.getAttribute("data-file"),10)));t.checked?(g+=1,p.push(e)):(p=p.filter((t=>t.id!==e.id)),g-=1);}1===g?s.innerHTML=skeletonTemplate:g>1&&(s.innerHTML="\n          <div class='text-center px-4'>\n            <span class=\"placeholder col-6 bg-body-secondary mb-3\"></span>\n            <img class='d-dark-none img-fluid' src='../../assets/img/spot-illustrations/46.png'>\n            <img class='d-light-none img-fluid' src='../../assets/img/spot-illustrations/dark_46.png'>\n          </div>\n        "),i.innerHTML="\n        <div class='text-center'>\n          <span class=\"placeholder bg-body-secondary\" style='width: 97px'></span>\n        </div>\n      ",0===g?(r.classList.add("d-none"),c.classList.add("d-block"),c.classList.remove("d-none")):(c.classList.add("d-none"),r.classList.add("d-block"),r.classList.remove("d-none")),b=setTimeout((()=>{b=null,f();}),300);}})),e.addEventListener("dblclick",(e=>{const t=e.target;if(t.hasAttribute("data-file")){u.deselectAll(c,r),p=[],g=1;const s=myFiles.find((e=>e.id===parseInt(t.getAttribute("data-file"),10)));p.push(s),e.target.previousElementSibling.checked=!0,c.classList.add("d-none"),r.classList.add("d-block"),r.classList.remove("d-none"),f();}t.hasAttribute("data-file-thumbnail")&&window.GLightbox({elements:h,autoplayVideos:!0,startAt:parseInt(t.getAttribute("data-file-index"),10)}).open();}));const L=()=>{a.forEach((e=>{window.innerWidth>1539?t.classList.contains("d-xxl-none")?e.setAttribute("data-bs-title","Show details"):e.setAttribute("data-bs-title","Hide details"):e.setAttribute("data-bs-title","Show details");const s=window.bootstrap.Tooltip.getInstance(e);s?s.setContent({".tooltip-inner":e.getAttribute("data-bs-title")}):window.bootstrap.Tooltip(e);}));};a.forEach((e=>{e.addEventListener("click",(()=>{window.innerWidth>1539&&(t.classList.contains("d-xxl-none")?t.classList.remove("d-xxl-none"):t.classList.add("d-xxl-none"),t.previousElementSibling.classList.contains("w-xxl-100")?t.previousElementSibling.classList.remove("w-xxl-100"):t.previousElementSibling.classList.add("w-xxl-100")),L();}));})),window.addEventListener("load",(()=>L())),window.addEventListener("resize",(()=>L())),o.addEventListener("click",(()=>{u&&(u.deselectAll(c,r),p=[],g=0,f());})),n.addEventListener("click",(()=>{l.classList.toggle("show-sidebar");}));};

  const{docReady:docReady}=window.phoenix.utils;docReady(fileManagerInit);

}));
//# sourceMappingURL=file-manager.js.map
