(function (factory) {
  typeof define === 'function' && define.amd ? define(factory) :
  factory();
})((function () { 'use strict';

  const ganttData={tasks:[{id:11,text:"Travel agency landing page design",progress:.6,open:!0,priority:"Urgent",assignee:[{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Jerry Seinfield",img:"/team/9.webp"}]},{id:12,text:"Research",start_date:"03-04-2023",duration:55,parent:11,progress:1,open:!0,priority:"High",assignee:[{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Barbara Lucas",img:"/team/3.webp"}]},{id:13,text:"Planning",parent:11,progress:.6,open:!0,priority:"Medium",assignee:[{name:"Lina Burton",img:"/team/2.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Barbara Lucas",img:"/team/3.webp"}]},{id:14,text:"Design",start_date:"25-04-2023",duration:40,parent:11,progress:.8,open:!0,priority:"High",assignee:[{name:"Lina Burton",img:"/team/2.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Barbara Lucas",img:"/team/3.webp"}]},{id:15,text:"Development",start_date:"10-05-2023",duration:40,parent:11,progress:.8,open:!0,priority:"High",assignee:[{name:"Igor Borvibson",img:"/team/1.webp"}]},{id:16,text:"Testing",start_date:"05-06-2023",duration:23,type:"milestone",parent:11,progress:0,open:!0,priority:"High",assignee:[{name:"Emma Watson",img:"/team/4.webp"},{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Jerry Seinfield",img:"/team/9.webp"}]},{id:17,text:"Deployment",start_date:"03-04-2023",duration:52,parent:13,progress:1,open:!0,priority:"Low",assignee:[{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Emma Watson",img:"/team/4.webp"}]},{id:24,text:"Design finance app for phoenix",progress:.5,open:!0,priority:"High",assignee:[{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Jerry Seinfield",img:"/team/9.webp"}]},{id:25,text:"Update figma file for phoenix",start_date:"04-04-2023",duration:55,progress:0,open:!0,priority:"High",assignee:[{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Jerry Seinfield",img:"/team/9.webp"}]},{id:26,text:"Falcon figma file update",start_date:"10-04-2023",duration:47,progress:0,open:!0,priority:"High",assignee:[{name:"Jerry Seinfield",img:"/team/9.webp"},{name:"Lina Burton",img:"/team/2.webp"},{name:"Igor Borvibson",img:"/team/1.webp"}]},{id:27,text:"Gantt chart design",start_date:"15-04-2023",duration:45,progress:0,open:!0,priority:"Medium",assignee:[{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Lina Burton",img:"/team/2.webp"}]},{id:28,text:"Design for new dashboard aurora",start_date:"25-06-2023",duration:112,progress:0,open:!0,priority:"High",assignee:[{name:"Jerry Seinfield",img:"/team/9.webp"},{name:"Igor Borvibson",img:"/team/1.webp"}]},{id:29,text:"Research for new module",start_date:"28-04-2023",duration:57,progress:0,open:!0,priority:"Low",assignee:[{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Lina Burton",img:"/team/2.webp"}]},{id:30,text:"Research",start_date:"04-04-2023",duration:60,progress:0,open:!0,priority:"Low",parent:24,assignee:[{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Lina Burton",img:"/team/2.webp"}]},{id:31,text:"Development",start_date:"16-04-2023",duration:68,progress:0,parent:24,open:!0,priority:"Low",assignee:[{name:"Lina Burton",img:"/team/2.webp"},{name:"Emma Watson",img:"/team/4.webp"},{name:"Igor Borvibson",img:"/team/1.webp"},{name:"Barbara Lucas",img:"/team/3.webp"}]},{id:33,text:"Deployment",start_date:"27-05-2023",duration:32,progress:0,parent:24,open:!0,priority:"Low",assignee:[{name:"Barbara Lucas",img:"/team/3.webp"},{name:"Lina Burton",img:"/team/2.webp"}]}],links:[{id:10,source:11,target:12,type:1},{id:11,source:11,target:13,type:1},{id:12,source:11,target:14,type:1},{id:13,source:11,target:15,type:1},{id:14,source:23,target:16,type:0},{id:15,source:13,target:17,type:1},{id:16,source:17,target:18,type:0},{id:17,source:18,target:19,type:0},{id:18,source:19,target:20,type:0},{id:19,source:15,target:21,type:2},{id:20,source:15,target:22,type:2},{id:21,source:15,target:23,type:0},{id:29,source:24,target:30,type:1},{id:30,source:24,target:31,type:1},{id:33,source:24,target:31,type:1}]};

  const{gantt:gantt$1}=window;const formatDate=t=>new Date(t).toLocaleDateString("en-US",{year:"numeric",month:"short",day:"numeric"});const ganttConfigColumnsData=[{name:"text",label:"PROJECT NAME",tree:!0,width:410,min_width:80,template(t){const a=gantt$1.getChildren(t.id).length;return `<div class='gantt-task-title-wrapper'> \n          <span class='gantt-task-title'>${t.text} </span>\n          ${a?`<span class="badge text-bg-primary">${a}</span>`:""}\n          <button data-gantt-add-subtask id=${t.id} class='btn btn-subtle-info  gantt-task-title-btn'><span class='fa-solid fa-plus'/></button>\n        </div>`}},{name:"assignee",label:"ASSIGNEE",width:160,template(t){if(t.type===gantt$1.config.types.project)return "";const a="../assets/img/",e=t.assignee||[];if(!e.length)return "Unassigned";return `<div class="d-flex align-items-center avatar-group">${e.map(((t,n)=>e.length>4&&3===n?`\n                <a href='#!' data-bs-toggle='dropdown' aria-expanded='false' data-bs-auto-close='outside'\n                  class='dropdown-toggle dropdown-caret-none avatar avatar-s'>\n                  <div class='avatar-name rounded-circle border border-translucent'>\n                    <span>+${e.length-3}</span>\n                  </div>\n                </a>\n                <ul class="dropdown-menu dropdown-menu-end py-2">\n                  ${e.map((t=>`<div class='dropdown-item py-2 px-3 d-flex gap-2 align-items-center'>\n                          <div class='avatar avatar-s'>\n                            <img class="rounded-circle" src="${a}${t.img}" alt="${t.name||"assignee"}"\n                              />\n                          </div>\n                          <a href="#" class='fw-bold text-body text-decoration-none lh-1'>${t.name}</a>\n                        </div>`)).join("")}\n                </ul>   \n              `:n<=3?`\n                 <div data-bs-toggle='dropdown' data-bs-auto-close='outside' class='avatar avatar-s dropdown-toggle dropdown-caret-none'>\n                      <img class="rounded-circle" src="${a}${t.img}" alt="${t.name||"assignee"}"\n                        />\n                </div>\n                <ul class="dropdown-menu dropdown-menu-end py-0">\n                  <div class='dropdown-item py-0 px-3 d-flex gap-3 align-items-center'>\n                          <div class='avatar avatar-s'>\n                            <img class="rounded-circle" src="${a}${t.img}" alt="${t.name||"assignee"}"\n                              />\n                          </div>\n                          <a href="#" class='fw-bold text-body text-decoration-none lh-1 py-3'>${t.name}</a>\n                        </div>\n                </ul>\n              `:"")).join("")}</div>`},sort:!1},{name:"Priority",label:"PRIORITY",width:160,min_width:50,template(t){const a=t.priority?.toLowerCase();let e;switch(a){case"urgent":e="danger";break;case"high":e="warning";break;case"medium":e="success";break;default:e="info";}return `<div class='text-body'><span class='fa-solid fa-circle text-${e} me-1 fs-10'></span>${t.priority||"Low"}</div>`},sort(t,a){const e=t.priority.toLowerCase(),n=a.priority.toLowerCase();return e<n?-1:e>n?1:0}},{name:"start_date",label:"START DATE",align:"start",width:160,template:t=>`\n         <span class='uil uil-calendar-alt text-body-quaternary fs-8 me-1'></span> ${formatDate(t.start_date)} \n      `},{name:"end_date",label:"END DATE",align:"start",width:160,template:t=>`\n       <span class='uil uil-calendar-alt text-body-quaternary fs-8 me-1'></span> ${formatDate(t.end_date)} \n    `},{name:"duration",label:"DURATION",align:"start",width:160,template:t=>`\n        <span class='uil uil-clock me-1 fs-8 text-quaternary'></span>\n        ${t.duration} days \n    `}];const taskTextHandler=t=>{gantt$1.config.font_width_ratio=7;const a=a=>{const e=gantt$1.posFromDate(a.start_date),n=gantt$1.posFromDate(a.end_date),s=t?e:n,r=s-(t?n:e),o=(a.text||"").length*gantt$1.config.font_width_ratio;if(r<o){const t=gantt$1.getState().max_date;return gantt$1.posFromDate(t)-s<o?"left":"right"}return "center"};gantt$1.templates.leftside_text=(t,e,n)=>"left"===a(n)?n.text:"",gantt$1.templates.rightside_text=(t,e,n)=>"right"===a(n)?n.text:"",gantt$1.templates.task_text=(t,e,n)=>"center"===a(n)?n.text:"";};

  const{gantt:gantt}=window,Selectors={DATA_GANTT_SEARCH:"[data-gantt-search]",DATA_GANTT_SEARCH_DISMISS:"[data-gantt-search-dismiss]",DATA_GANTT_VIEW:"[data-gantt-view]",DATA_DELETE_LINK_MODAL:"#dataDeleteLinkModal",DATA_GANTT_ZOOM:"data-gantt-zoom",DATA_GANTT_ADD_TASK:"[data-gantt-add-task]",DATA_GANTT_ADD_SUBTASK:"[data-gantt-add-subtask]",TASK_DETAILS_OFFCANVAS:"#taskDetailsOffcanvas",TASK_DETAILS_NAME:"#taskDetailsName",TASK_DETAILS_START_DATE:"#taskDetailsStartDate",TASK_DETAILS_END_DATE:"#taskDetailsEndDate",TASK_DETAILS_DURATION:"#taskDetailsDuration",GANTT_ADD_TASK_MODAL:"#ganttAddTaskModal",CREATE_TASK_NAME:"createTaskName",CREATE_TASK_START_DATE:"createTaskStartDate",CREATE_TASK_DURATION:"createTaskDuration",CREATE_NEW_TASK:"#createNewTask",GANTT_UPDATE_TASK:"ganttUpdateTask",GANTT_DELETE_TASK:"#ganttDeleteTask",GANTT_CONFIRM_DELETE_TASK:"#ganttConfirmDeleteTask",GANTT_DELETE_TASK_MODAL:"#ganttDeleteTaskModal",GANTT_DELETE_LINK_MODAL:"#ganttDeleteLinkModal",GANTT_DELETE_LINK_BTN:"#ganttDeleteLinkBtn",GANTT_ZOOM_TO_FIT:"#ganttZoomToFit"},Views={DAYS:"days",WEEKS:"weeks",MONTHS:"months",YEARS:"years"},Events={CLICK:"click",INPUT:"input",ON_TASK_DBL_CLICK:"onTaskDblClick",ON_TASK_CREATED:"onTaskCreated",ON_LINK_DBL_CLICK:"onLinkDblClick",SHOWN_BS_MODAL:"shown.bs.modal",HIDDEN_BS_OFFCANVAS:"hidden.bs.offcanvas",ON_BEFORE_TASK_DISPLAY:"onBeforeTaskDisplay"},weekScaleTemplate=t=>{const e=gantt.date.date_to_str("%M %d"),a=gantt.date.add(t,7-t.getDay(),"day");return `${e(t)} - ${e(a)}`},scales={days:[{unit:"week",step:1,format:"%W"},{unit:"day",step:1,format:"%d %M"}],weeks:[{unit:"month",step:1,format:"%F"},{unit:"week",step:1,format:weekScaleTemplate}],months:[{unit:"year",step:1,format:"%Y"},{unit:"month",step:1,format:"%F"}],years:[{unit:"year",step:3,format(t){const e=gantt.date.date_to_str("%Y"),a=gantt.date.add(t,3,"year");return `${e(t)} - ${e(a)}`}},{unit:"year",step:1,format:"%Y"}]},searchHandler=()=>{let t="";const e=document.querySelector(Selectors.DATA_GANTT_SEARCH),a=document.querySelector(Selectors.DATA_GANTT_SEARCH_DISMISS);a?.addEventListener(Events.CLICK,(()=>{t="",e.value="",a?.classList.remove("d-block"),gantt.render();})),e?.addEventListener(Events.INPUT,(()=>{e.value.length>0?a?.classList.add("d-block"):a?.classList.remove("d-block"),t=e.value,gantt.render();}));const n=(e,a=!1)=>(gantt.eachTask((t=>{n(t)&&(a=!0);}),e.id),e.text.toLowerCase().includes(t.toLowerCase())&&(a=!0),a);gantt.attachEvent(Events.ON_BEFORE_TASK_DISPLAY,((e,a)=>!t||n(a)));},linkDeleteHandler=()=>{let t;const e=document.querySelector(Selectors.GANTT_DELETE_LINK_MODAL),a=new window.bootstrap.Modal(e);gantt.attachEvent(Events.ON_LINK_DBL_CLICK,(e=>(t=e,a.show(),!1)));document.querySelector(Selectors.GANTT_DELETE_LINK_BTN).addEventListener(Events.CLICK,(()=>{t&&gantt.deleteLink(t),a.hide();}));};let currentTaskId;const taskDeleteHandler=()=>{const t=document.querySelector(Selectors.GANTT_DELETE_TASK);if(t){let e=!1;t.addEventListener("click",(()=>{e=!0;const t=document.querySelector(Selectors.TASK_DETAILS_OFFCANVAS);window.bootstrap.Offcanvas.getInstance(t).hide();const a=document.querySelector(Selectors.GANTT_DELETE_TASK_MODAL);console.log(a);const n=new window.bootstrap.Modal(a);t.addEventListener("hidden.bs.offcanvas",(()=>{e&&(a&&n.show(),e=!1);})),a.addEventListener(Events.SHOWN_BS_MODAL,(()=>{const t=document.querySelector(Selectors.GANTT_CONFIRM_DELETE_TASK);t&&t.addEventListener(Events.CLICK,(()=>{currentTaskId&&(gantt.deleteTask(currentTaskId),n.hide());}));}));}));}},ganttChartInit=()=>{const{getItemFromStore:t,breakpoints:e}=window.phoenix.utils;if(!document.querySelector("#gantt-app"))return;gantt.plugins({}),gantt.config.scales=scales.months,gantt.config.row_height=48,gantt.config.scale_height=70,gantt.config.bar_height=16,gantt.config.sort=!0,gantt.config.grid_resizer=!0,gantt.config.min_column_width=130,gantt.config.columns=ganttConfigColumnsData;const a={width:518,rows:[{view:"grid",scrollX:"gridScroll",scrollable:!0,scrollY:"scrollVer"},{view:"scrollbar",id:"gridScroll"}]},n={rows:[{view:"timeline",scrollX:"scrollHor",scrollY:"scrollVer"},{view:"scrollbar",id:"scrollHor"}]},o={view:"scrollbar",id:"scrollVer"},s={resizer:!0,width:1};gantt.config.layout={css:"gantt_container",cols:[a,s,n,o]};const r=t("phoenixIsRTL");r&&(gantt.config.rtl=!0,gantt.config.layout={css:"gantt_container",cols:[o,n,s,a]}),taskTextHandler(r),gantt.config.scroll_size=7,gantt.init("gantt-app"),gantt.parse(ganttData),gantt.templates.grid_header_class=t=>"assignee"===t?"sort-btn-none":"";const c=t=>{switch(t){case Views.DAYS:gantt.config.scales=scales.days;break;case Views.WEEKS:gantt.config.scales=scales.weeks;break;case Views.MONTHS:gantt.config.scales=scales.months;break;case Views.YEARS:gantt.config.scales=scales.years;break;default:gantt.config.scales=scales.months;}gantt.render();};let T=Views.DAYS;document.querySelector("[data-gantt-view]")?.addEventListener("change",(t=>{document.querySelector(Selectors.GANTT_ZOOM_TO_FIT).checked&&(document.querySelector(Selectors.GANTT_ZOOM_TO_FIT).checked=!1),T=t.target.value,c(t.target.value);})),document.addEventListener(Events.CLICK,(t=>{const e=t.target.hasAttribute(Selectors.DATA_GANTT_ZOOM)?t.target:t.target.closest([Selectors.DATA_GANTT_ZOOM]),a=t.target.closest(Selectors.DATA_GANTT_ADD_TASK),n=t.target.closest(Selectors.DATA_GANTT_ADD_SUBTASK);if(e){let t;if("checkbox"===e?.getAttribute("type")){t=Views.MONTHS;const a=e.checked;c(a?t:T),document.querySelector(Selectors.DATA_GANTT_VIEW).value=a?t:T;}else document.querySelector(Selectors.GANTT_ZOOM_TO_FIT).checked&&(document.querySelector(Selectors.GANTT_ZOOM_TO_FIT).checked=!1),c(t);}a?gantt.createTask({text:"",duration:5}):n&&gantt.createTask({text:"",duration:3,parent:n.getAttribute("id")});}));const l=()=>{gantt.$root.style.width="100%";const{cols:t}=gantt.config.layout,a=t.find((t=>"grid"===t.rows?.[0]?.view))||{};window.innerWidth<=e.sm?a.width=200:window.innerWidth<=e.md?a.width=280:window.innerWidth<=e.lg?a.width=300:window.innerWidth<=e.xl?a.width=420:a.width=518,gantt.init("gantt-app");};l(),window.addEventListener("resize",l),gantt.attachEvent(Events.ON_TASK_DBL_CLICK,(t=>{const e=gantt.getTask(t);currentTaskId=t;const a=document.querySelector(Selectors.TASK_DETAILS_OFFCANVAS);if(a){new window.bootstrap.Offcanvas(a).show();const t=a.querySelector(Selectors.TASK_DETAILS_NAME);t&&(t.value=e.text);const n=window.flatpickr(Selectors.TASK_DETAILS_START_DATE,{dateFormat:"M j, Y",disableMobile:!0,defaultDate:"Mar 1, 2022"}),o=window.flatpickr(Selectors.TASK_DETAILS_END_DATE,{dateFormat:"M j, Y",disableMobile:!0,defaultDate:"Mar 1, 2022"}),s=formatDate(e.start_date),r=formatDate(e.end_date);n.setDate(s,!0),o.setDate(r,!0),document.querySelector(Selectors.TASK_DETAILS_DURATION).value=e.duration;}return !1})),gantt.attachEvent(Events.ON_TASK_CREATED,(t=>{const e=document.querySelector(Selectors.GANTT_ADD_TASK_MODAL),a=new window.bootstrap.Modal(e);return a.show(),document.getElementById(Selectors.CREATE_TASK_NAME).value=t.text||"",document.querySelector(Selectors.CREATE_NEW_TASK).onclick=()=>{const e=document.getElementById(Selectors.CREATE_TASK_NAME).value,n=new Date(document.getElementById(Selectors.CREATE_TASK_START_DATE).value),o=document.getElementById(Selectors.CREATE_TASK_DURATION).value||2,s=gantt.calculateEndDate({start_date:n,duration:o,task:{}});e&&n&&s&&(t.text=e,t.start_date=n,t.end_date=s,gantt.addTask(t),a.hide());},!1})),document.getElementById(Selectors.GANTT_UPDATE_TASK)?.addEventListener(Events.CLICK,(()=>{const t=document.querySelector(Selectors.TASK_DETAILS_OFFCANVAS),e=t.querySelector(Selectors.TASK_DETAILS_NAME).value,a=gantt.getTask(currentTaskId),n=new Date(document.querySelector(Selectors.TASK_DETAILS_START_DATE).value),o=document.querySelector(Selectors.TASK_DETAILS_DURATION).value,s=gantt.calculateEndDate({start_date:n,duration:o,task:{}});e&&n&&s&&o&&(a.text=e,a.start_date=n,a.duration=o,a.end_date=s,gantt.updateTask(a.id,a),window.bootstrap.Offcanvas.getInstance(t).hide());})),taskDeleteHandler(),linkDeleteHandler(),searchHandler();};

  const{docReady:docReady}=window.phoenix.utils;docReady(ganttChartInit);

}));
//# sourceMappingURL=gantt-chart.js.map
